/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.citadel.server.entity.datatracker.EntityPropertiesHandler;
import com.github.alexthe666.citadel.server.item.CustomToolMaterial;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.props.FrozenEntityProperties;
import com.github.alexthe666.iceandfire.item.DragonsteelToolMaterial;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemModSword
extends SwordItem {
    private final CustomToolMaterial toolMaterial;
    private Multimap<Attribute, AttributeModifier> dragonsteelModifiers;

    public ItemModSword(CustomToolMaterial toolmaterial, String gameName) {
        super((IItemTier)toolmaterial, 3, -2.4f, new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS));
        this.toolMaterial = toolmaterial;
        this.setRegistryName("iceandfire", gameName);
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND && this.toolMaterial instanceof DragonsteelToolMaterial ? this.bakeDragonsteel() : super.func_111205_h(equipmentSlot);
    }

    private Multimap<Attribute, AttributeModifier> bakeDragonsteel() {
        if ((double)this.toolMaterial.func_200929_c() != IafConfig.dragonsteelBaseDamage || this.dragonsteelModifiers == null) {
            ImmutableMultimap.Builder lvt_5_1_ = ImmutableMultimap.builder();
            lvt_5_1_.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", IafConfig.dragonsteelBaseDamage - 1.0, AttributeModifier.Operation.ADDITION));
            lvt_5_1_.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
            this.dragonsteelModifiers = lvt_5_1_.build();
            return this.dragonsteelModifiers;
        }
        return this.dragonsteelModifiers;
    }

    public float func_200894_d() {
        return this.toolMaterial instanceof DragonsteelToolMaterial ? (float)IafConfig.dragonsteelBaseDamage : super.func_200894_d();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.toolMaterial == IafItemRegistry.SILVER_TOOL_MATERIAL && target.func_70668_bt() == CreatureAttribute.field_223223_b_) {
            target.func_70097_a(DamageSource.field_76376_m, this.func_200894_d() + 3.0f);
        }
        if (this.toolMaterial == IafItemRegistry.MYRMEX_CHITIN_TOOL_MATERIAL) {
            if (target.func_70668_bt() != CreatureAttribute.field_223224_c_) {
                target.func_70097_a(DamageSource.field_76377_j, this.func_200894_d() + 5.0f);
            }
            if (target instanceof EntityDeathWorm) {
                target.func_70097_a(DamageSource.field_76377_j, this.func_200894_d() + 5.0f);
            }
            if (this == IafItemRegistry.MYRMEX_DESERT_SWORD_VENOM || this == IafItemRegistry.MYRMEX_JUNGLE_SWORD_VENOM) {
                target.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 1));
            }
        }
        if (this.toolMaterial == IafItemRegistry.DRAGONSTEEL_FIRE_TOOL_MATERIAL && IafConfig.dragonWeaponFireAbility) {
            target.func_70015_d(15);
            target.func_233627_a_(1.0f, attacker.func_226277_ct_() - target.func_226277_ct_(), attacker.func_226281_cx_() - target.func_226281_cx_());
        }
        if (this.toolMaterial == IafItemRegistry.DRAGONSTEEL_ICE_TOOL_MATERIAL && IafConfig.dragonWeaponIceAbility) {
            FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)target, FrozenEntityProperties.class);
            frozenProps.setFrozenFor(300);
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 2));
            target.func_233627_a_(1.0f, attacker.func_226277_ct_() - target.func_226277_ct_(), attacker.func_226281_cx_() - target.func_226281_cx_());
        }
        if (this.toolMaterial == IafItemRegistry.DRAGONSTEEL_LIGHTNING_TOOL_MATERIAL && IafConfig.dragonWeaponLightningAbility) {
            boolean flag = true;
            if (attacker instanceof PlayerEntity && (double)((PlayerEntity)attacker).field_70733_aJ > 0.2) {
                flag = false;
            }
            if (!attacker.field_70170_p.field_72995_K && flag) {
                LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(target.field_70170_p);
                lightningboltentity.func_233576_c_(target.func_213303_ch());
                if (!target.field_70170_p.field_72995_K) {
                    target.field_70170_p.func_217376_c((Entity)lightningboltentity);
                }
            }
            target.func_233627_a_(1.0f, attacker.func_226277_ct_() - target.func_226277_ct_(), attacker.func_226281_cx_() - target.func_226281_cx_());
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.toolMaterial == IafItemRegistry.SILVER_TOOL_MATERIAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent("silvertools.hurt").func_240699_a_(TextFormatting.GREEN));
        }
        if (this.toolMaterial == IafItemRegistry.MYRMEX_CHITIN_TOOL_MATERIAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent("myrmextools.hurt").func_240699_a_(TextFormatting.GREEN));
        }
        if (this.toolMaterial == IafItemRegistry.DRAGONSTEEL_FIRE_TOOL_MATERIAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent("dragon_sword_fire.hurt2").func_240699_a_(TextFormatting.DARK_RED));
        }
        if (this.toolMaterial == IafItemRegistry.DRAGONSTEEL_ICE_TOOL_MATERIAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent("dragon_sword_ice.hurt2").func_240699_a_(TextFormatting.AQUA));
        }
        if (this.toolMaterial == IafItemRegistry.DRAGONSTEEL_LIGHTNING_TOOL_MATERIAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent("dragon_sword_lightning.hurt2").func_240699_a_(TextFormatting.DARK_PURPLE));
        }
    }
}

