/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonSkull;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.item.ICustomRendered;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemDragonSkull
extends Item
implements ICustomRendered {
    private int dragonType;

    public ItemDragonSkull(int dragonType) {
        super(new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS).func_200917_a(1));
        this.dragonType = dragonType;
        this.setRegistryName("iceandfire", "dragon_skull_" + this.getType(dragonType));
    }

    private String getType(int type) {
        if (type == 2) {
            return "lightning";
        }
        if (type == 1) {
            return "ice";
        }
        return "fire";
    }

    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity player) {
        itemStack.func_77982_d(new CompoundNBT());
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("Stage", 4);
            stack.func_77978_p().func_74768_a("DragonAge", 75);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String iceorfire = "dragon." + this.getType(this.dragonType);
        tooltip.add((ITextComponent)new TranslationTextComponent(iceorfire).func_240699_a_(TextFormatting.GRAY));
        if (stack.func_77978_p() != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("dragon.stage").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(" " + stack.func_77978_p().func_74762_e("Stage"))));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        if (stack.func_77978_p() != null) {
            EntityDragonSkull skull = new EntityDragonSkull(IafEntityRegistry.DRAGON_SKULL, context.func_195991_k());
            skull.setDragonType(this.dragonType);
            skull.setStage(stack.func_77978_p().func_74762_e("Stage"));
            skull.setDragonAge(stack.func_77978_p().func_74762_e("DragonAge"));
            BlockPos offset = context.func_195995_a().func_177967_a(context.func_196000_l(), 1);
            skull.func_70012_b((double)offset.func_177958_n() + 0.5, offset.func_177956_o(), (double)offset.func_177952_p() + 0.5, 0.0f, 0.0f);
            float yaw = context.func_195999_j().field_70177_z;
            if (context.func_196000_l() != Direction.UP) {
                yaw = context.func_195999_j().func_174811_aO().func_185119_l();
            }
            skull.setYaw(yaw);
            if (stack.func_82837_s()) {
                skull.func_200203_b(stack.func_200301_q());
            }
            if (!context.func_195991_k().field_72995_K) {
                context.func_195991_k().func_217376_c((Entity)skull);
            }
            if (!context.func_195999_j().func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }
}

