/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntitSlowPart;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpentBubbles;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.FlyingAITarget;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIGetInWater;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIJump;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIMeleeJump;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIRandomSwimming;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentPathNavigator;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IMultipartEntity;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntitySeaSerpent
extends AnimalEntity
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)15);
    public static final Animation ANIMATION_ROAR = Animation.create((int)40);
    public static final int TIME_BETWEEN_ROARS = 300;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> JUMPING = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BREATHING = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ANCIENT = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final com.google.common.base.Predicate NOT_SEA_SERPENT = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof LivingEntity && !(entity instanceof EntitySeaSerpent) && DragonUtils.isAlive((LivingEntity)entity);
        }
    };
    private static final com.google.common.base.Predicate NOT_SEA_SERPENT_IN_WATER = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof LivingEntity && !(entity instanceof EntitySeaSerpent) && DragonUtils.isAlive((LivingEntity)entity) && entity.func_203005_aq();
        }
    };
    public int swimCycle;
    public float jumpProgress = 0.0f;
    public float wantJumpProgress = 0.0f;
    public float jumpRot = 0.0f;
    public float prevJumpRot = 0.0f;
    public float breathProgress = 0.0f;
    public boolean attackDecision = false;
    private int animationTick;
    private Animation currentAnimation;
    private EntityMutlipartPart[] segments = new EntityMutlipartPart[9];
    private float lastScale;
    private boolean isLandNavigator;
    private boolean changedSwimBehavior = false;
    public int jumpCooldown = 0;
    private int ticksSinceRoar = 0;
    private boolean isBreathing;
    private float[] tailYaw = new float[5];
    private float[] prevTailYaw = new float[5];
    private float[] tailPitch = new float[5];
    private float[] prevTailPitch = new float[5];

    public EntitySeaSerpent(EntityType t, World worldIn) {
        super(t, worldIn);
        this.switchNavigator(false);
        this.field_70158_ak = true;
        this.resetParts(1.0f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    private static BlockPos clampBlockPosToWater(Entity entity, World world, BlockPos pos) {
        BlockPos topY = new BlockPos((double)pos.func_177958_n(), entity.func_226278_cu_(), (double)pos.func_177952_p());
        BlockPos bottomY = new BlockPos((double)pos.func_177958_n(), entity.func_226278_cu_(), (double)pos.func_177952_p());
        while (EntitySeaSerpent.isWaterBlock(world, topY) && topY.func_177956_o() < world.func_217301_I()) {
            topY = topY.func_177984_a();
        }
        while (EntitySeaSerpent.isWaterBlock(world, bottomY) && bottomY.func_177956_o() > 0) {
            bottomY = bottomY.func_177977_b();
        }
        return new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)(bottomY.func_177956_o() + 1), (int)(topY.func_177956_o() - 1)), pos.func_177952_p());
    }

    public static boolean isWaterBlock(World world, BlockPos pos) {
        return world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SeaSerpentAIGetInWater(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SeaSerpentAIMeleeJump(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SeaSerpentAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new SeaSerpentAIRandomSwimming((CreatureEntity)this, 1.0, 2));
        this.field_70714_bg.func_75776_a(3, (Goal)new SeaSerpentAIJump(this, 4));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityMutlipartPart.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new FlyingAITarget((MobEntity)this, LivingEntity.class, 150, false, false, NOT_SEA_SERPENT_IN_WATER));
        this.field_70715_bh.func_75776_a(3, (Goal)new FlyingAITarget((MobEntity)this, PlayerEntity.class, 0, false, false, NOT_SEA_SERPENT));
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.isAncient() ? 30 : 15;
    }

    public void func_85033_bc() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        entities.stream().filter(entity -> !(entity instanceof EntityMutlipartPart) && entity.func_70104_M()).forEach(entity -> entity.func_70108_f((Entity)this));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.field_70699_by.func_212239_d(true);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new SwimmingMoveHelper(this);
            this.field_70699_by = new SeaSerpentPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public boolean isDirectPathBetweenPoints(BlockPos pos) {
        Vector3d bector3d1;
        Vector3d vector3d = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, bector3d1 = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.seaSerpentBaseHealth).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, (double)Math.min(2048, IafConfig.dragonTargetSearchLength)).func_233815_a_(Attributes.field_233826_i_, 3.0);
    }

    public void resetParts(float scale) {
        this.clearParts();
        this.segments = new EntityMutlipartPart[9];
        for (int i = 0; i < this.segments.length; ++i) {
            EntitySeaSerpent parentToSet;
            if (i > 3) {
                parentToSet = i <= 4 ? this : this.segments[i - 1];
                this.segments[i] = new EntitSlowPart((Entity)parentToSet, 0.5f * scale, 180.0f, 0.0f, 0.5f * scale, 0.5f * scale, 1.0f);
            } else {
                parentToSet = i == 0 ? this : this.segments[i - 1];
                this.segments[i] = new EntitSlowPart((Entity)parentToSet, -0.4f * scale, 180.0f, 0.0f, 0.45f * scale, 0.4f * scale, 1.0f);
            }
            this.segments[i].func_82149_j((Entity)this);
        }
    }

    public void onUpdateParts() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null || entity.shouldContinuePersisting()) continue;
            this.field_70170_p.func_217376_c((Entity)entity);
        }
    }

    private void clearParts() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            entity.func_70106_y();
        }
    }

    public void func_70106_y() {
        this.clearParts();
        super.func_70106_y();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
    }

    public float func_213355_cm() {
        return this.getSeaSerpentScale();
    }

    public void func_213323_x_() {
        super.func_213323_x_();
        float scale = this.getSeaSerpentScale();
        if (scale != this.lastScale) {
            this.resetParts(this.getSeaSerpentScale());
        }
        this.lastScale = scale;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        int i;
        super.func_70071_h_();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        this.func_213323_x_();
        this.onUpdateParts();
        if (this.func_70090_H()) {
            this.spawnParticlesAroundEntity((IParticleData)ParticleTypes.field_197612_e, (Entity)this, (int)this.getSeaSerpentScale());
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        for (i = 0; i < this.tailYaw.length; ++i) {
            this.prevTailYaw[i] = this.tailYaw[i];
        }
        for (i = 0; i < this.tailPitch.length; ++i) {
            this.prevTailPitch[i] = this.tailPitch[i];
        }
        this.tailYaw[0] = this.field_70761_aq;
        this.tailPitch[0] = this.field_70125_A;
        for (i = 1; i < this.tailYaw.length; ++i) {
            this.tailYaw[i] = this.prevTailYaw[i - 1];
        }
        for (i = 1; i < this.tailPitch.length; ++i) {
            this.tailPitch[i] = this.prevTailPitch[i - 1];
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public float getPieceYaw(int index, float partialTicks) {
        if (index < this.segments.length && index >= 0) {
            return this.prevTailYaw[index] + (this.tailYaw[index] - this.prevTailYaw[index]) * partialTicks;
        }
        return 0.0f;
    }

    public float getPiecePitch(int index, float partialTicks) {
        if (index < this.segments.length && index >= 0) {
            return this.prevTailPitch[index] + (this.tailPitch[index] - this.prevTailPitch[index]) * partialTicks;
        }
        return 0.0f;
    }

    private void spawnParticlesAroundEntity(IParticleData type, Entity entity, int count) {
        for (int i = 0; i < count; ++i) {
            double z;
            double y;
            double x = entity.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * entity.func_213311_cf() * 2.0f) - (double)entity.func_213311_cf();
            if (this.field_70170_p.func_180495_p(new BlockPos(x, y = entity.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * entity.func_213302_cg()), z = entity.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * entity.func_213311_cf() * 2.0f) - (double)entity.func_213311_cf())).func_185904_a() != Material.field_151586_h) continue;
            this.field_70170_p.func_195594_a(type, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private void spawnSlamParticles(IParticleData type) {
        int i = 0;
        while ((float)i < this.getSeaSerpentScale() * 3.0f) {
            for (int i1 = 0; i1 < 5; ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float radius = 1.25f * this.getSeaSerpentScale();
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1 * 1.0f;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                if (!this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_195590_a(type, true, this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ, motionX, motionY, motionZ);
            }
            ++i;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(JUMPING, (Object)false);
        this.field_70180_af.func_187214_a(BREATHING, (Object)false);
        this.field_70180_af.func_187214_a(ANCIENT, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("TicksSinceRoar", this.ticksSinceRoar);
        compound.func_74768_a("JumpCooldown", this.jumpCooldown);
        compound.func_74776_a("Scale", this.getSeaSerpentScale());
        compound.func_74757_a("JumpingOutOfWater", this.isJumpingOutOfWater());
        compound.func_74757_a("AttackDecision", this.attackDecision);
        compound.func_74757_a("Breathing", this.isBreathing());
        compound.func_74757_a("Ancient", this.isAncient());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.ticksSinceRoar = compound.func_74762_e("TicksSinceRoar");
        this.jumpCooldown = compound.func_74762_e("JumpCooldown");
        this.setSeaSerpentScale(compound.func_74760_g("Scale"));
        this.setJumpingOutOfWater(compound.func_74767_n("JumpingOutOfWater"));
        this.attackDecision = compound.func_74767_n("AttackDecision");
        this.setBreathing(compound.func_74767_n("Breathing"));
        this.setAncient(compound.func_74767_n("Ancient"));
    }

    private void updateAttributes() {
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(Math.min(0.25, 0.15 * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(Math.max(4.0, IafConfig.seaSerpentAttackStrength * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(Math.max(10.0, IafConfig.seaSerpentBaseHealth * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)Math.min(2048, IafConfig.dragonTargetSearchLength));
        this.func_70691_i(30.0f * this.getSeaSerpentScale());
    }

    private float getAncientModifier() {
        return this.isAncient() ? 1.5f : 1.0f;
    }

    public float getSeaSerpentScale() {
        return Float.valueOf(((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue()).floatValue();
    }

    private void setSeaSerpentScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public boolean isJumpingOutOfWater() {
        return (Boolean)this.field_70180_af.func_187225_a(JUMPING);
    }

    public void setJumpingOutOfWater(boolean jump) {
        this.field_70180_af.func_187227_b(JUMPING, (Object)jump);
    }

    public boolean isAncient() {
        return (Boolean)this.field_70180_af.func_187225_a(ANCIENT);
    }

    public void setAncient(boolean ancient) {
        this.field_70180_af.func_187227_b(ANCIENT, (Object)ancient);
    }

    public boolean isBreathing() {
        if (this.field_70170_p.field_72995_K) {
            boolean breathing;
            this.isBreathing = breathing = ((Boolean)this.field_70180_af.func_187225_a(BREATHING)).booleanValue();
            return breathing;
        }
        return this.isBreathing;
    }

    public void setBreathing(boolean breathing) {
        this.field_70180_af.func_187227_b(BREATHING, (Object)breathing);
        if (!this.field_70170_p.field_72995_K) {
            this.isBreathing = breathing;
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        boolean breathing = this.isBreathing() && this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_ROAR;
        boolean jumping = !this.func_70090_H() && !this.func_233570_aj_() && this.func_213322_ci().field_72448_b >= 0.0;
        boolean wantJumping = false;
        boolean ground = !this.func_70090_H() && this.field_70122_E;
        boolean prevJumping = this.isJumpingOutOfWater();
        ++this.ticksSinceRoar;
        ++this.jumpCooldown;
        this.prevJumpRot = this.jumpRot;
        if (this.ticksSinceRoar > 300 && this.isAtSurface() && this.getAnimation() != ANIMATION_BITE && this.jumpProgress == 0.0f && !this.isJumpingOutOfWater()) {
            this.setAnimation(ANIMATION_ROAR);
            this.ticksSinceRoar = 0;
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 1) {
            this.func_184185_a(IafSoundRegistry.SEA_SERPENT_ROAR, this.func_70599_aP() + 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            this.func_184185_a(IafSoundRegistry.SEA_SERPENT_BITE, this.func_70599_aP(), 1.0f);
        }
        if (this.isJumpingOutOfWater() && EntitySeaSerpent.isWaterBlock(this.field_70170_p, this.func_233580_cy_().func_177981_b(2))) {
            this.setJumpingOutOfWater(false);
        }
        this.swimCycle = this.swimCycle < 38 ? (this.swimCycle += 2) : 0;
        if (breathing && this.breathProgress < 20.0f) {
            this.breathProgress += 0.5f;
        } else if (!breathing && this.breathProgress > 0.0f) {
            this.breathProgress -= 0.5f;
        }
        if (jumping && this.jumpProgress < 10.0f) {
            this.jumpProgress += 0.5f;
        } else if (!jumping && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 0.5f;
        }
        if (wantJumping && this.wantJumpProgress < 10.0f) {
            this.wantJumpProgress += 2.0f;
        } else if (!wantJumping && this.wantJumpProgress > 0.0f) {
            this.wantJumpProgress -= 2.0f;
        }
        if (this.isJumpingOutOfWater() && this.jumpRot < 1.0f) {
            this.jumpRot += 0.1f;
        } else if (!this.isJumpingOutOfWater() && this.jumpRot > 0.0f) {
            this.jumpRot -= 0.1f;
        }
        if (prevJumping && !this.isJumpingOutOfWater()) {
            this.func_184185_a(IafSoundRegistry.SEA_SERPENT_SPLASH, 5.0f, 0.75f);
            this.spawnSlamParticles((IParticleData)ParticleTypes.field_197612_e);
            this.doSplashDamage();
        }
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.field_70125_A = MathHelper.func_76131_a((float)((float)this.func_213322_ci().field_72448_b * 20.0f), (float)-90.0f, (float)90.0f);
        if (this.changedSwimBehavior) {
            this.changedSwimBehavior = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.attackDecision) {
                this.setBreathing(false);
            }
            if (this.func_70638_az() != null && this.getAnimation() != ANIMATION_ROAR) {
                if (!this.attackDecision) {
                    if (!this.func_70638_az().func_70090_H() || !this.func_70685_l((Entity)this.func_70638_az()) || this.func_70032_d((Entity)this.func_70638_az()) < 30.0f * this.getSeaSerpentScale()) {
                        this.attackDecision = true;
                    }
                    if (!this.attackDecision) {
                        this.shoot(this.func_70638_az());
                    }
                } else if (this.func_70068_e((Entity)this.func_70638_az()) > (double)(200.0f * this.getSeaSerpentScale())) {
                    this.attackDecision = false;
                }
            } else {
                this.setBreathing(false);
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && (this.isTouchingMob((Entity)this.func_70638_az()) || this.func_70068_e((Entity)this.func_70638_az()) < 50.0)) {
            this.hurtMob(this.func_70638_az());
        }
        this.breakBlock();
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH() && this.func_184208_bv() instanceof BoatEntity) {
            BoatEntity boat = (BoatEntity)this.func_184208_bv();
            boat.func_70106_y();
            this.func_184210_p();
        }
    }

    private boolean isAtSurface() {
        BlockPos pos = this.func_233580_cy_();
        return EntitySeaSerpent.isWaterBlock(this.field_70170_p, pos.func_177977_b()) && !EntitySeaSerpent.isWaterBlock(this.field_70170_p, pos.func_177984_a());
    }

    private void doSplashDamage() {
        double getWidth = 2.0 * (double)this.getSeaSerpentScale();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(getWidth, getWidth * 0.5, getWidth), (Predicate)NOT_SEA_SERPENT);
        for (Entity entity : list) {
            if (!(entity instanceof LivingEntity) || !DragonUtils.isAlive((LivingEntity)entity)) continue;
            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            this.destroyBoat(entity);
            double xRatio = this.func_226277_ct_() - entity.func_226277_ct_();
            double zRatio = this.func_226281_cx_() - entity.func_226281_cx_();
            float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
            float strength = 0.3f * this.getSeaSerpentScale();
            entity.func_213317_d(entity.func_213322_ci().func_216372_d(0.5, 1.0, 0.5));
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(xRatio / (double)f * (double)strength, (double)strength, zRatio / (double)f * (double)strength));
        }
    }

    public void destroyBoat(Entity sailor) {
        if (sailor.func_184187_bx() != null && sailor.func_184187_bx() instanceof BoatEntity && !this.field_70170_p.field_72995_K) {
            BoatEntity boat = (BoatEntity)sailor.func_184187_bx();
            boat.func_70106_y();
            if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                for (int i = 0; i < 3; ++i) {
                    boat.func_70099_a(new ItemStack((IItemProvider)Item.func_150898_a((Block)boat.func_184453_r().func_195933_b())), 0.0f);
                }
                for (int j = 0; j < 2; ++j) {
                    boat.func_199701_a_(new ItemStack((IItemProvider)Items.field_151055_y));
                }
            }
        }
    }

    private boolean isPreyAtSurface() {
        if (this.func_70638_az() != null) {
            BlockPos pos = this.func_70638_az().func_233580_cy_();
            return !EntitySeaSerpent.isWaterBlock(this.field_70170_p, pos.func_177981_b((int)Math.ceil(this.func_70638_az().func_213302_cg())));
        }
        return false;
    }

    private void hurtMob(LivingEntity entity) {
        if (this.getAnimation() == ANIMATION_BITE && entity != null && this.getAnimationTick() == 6) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            this.attackDecision = this.func_70681_au().nextBoolean();
        }
    }

    public void moveJumping() {
        float velocity = 0.5f;
        double x = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
        double z = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
        float f = MathHelper.func_76133_a((double)(x * x + z * z));
        x /= (double)f;
        z /= (double)f;
        this.func_213293_j(x *= (double)velocity, this.func_213322_ci().field_72448_b, z *= (double)velocity);
    }

    public boolean isTouchingMob(Entity entity) {
        if (this.func_174813_aQ().func_72321_a(1.0, 1.0, 1.0).func_72326_a(entity.func_174813_aQ())) {
            return true;
        }
        for (EntityMutlipartPart segment : this.segments) {
            if (!segment.func_174813_aQ().func_72321_a(1.0, 1.0, 1.0).func_72326_a(entity.func_174813_aQ())) continue;
            return true;
        }
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void breakBlock() {
        if (IafConfig.seaSerpentGriefing) {
            for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a) - 2; a <= (int)Math.round(this.func_174813_aQ().field_72336_d) + 2; ++a) {
                for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b) - 1; b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 2 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c) - 2; c <= (int)Math.round(this.func_174813_aQ().field_72334_f) + 2; ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.field_70170_p.func_180495_p(pos);
                        FluidState fluidState = this.field_70170_p.func_204610_c(pos);
                        Block block = state.func_177230_c();
                        if (state.func_196958_f() || state.func_196954_c((IBlockReader)this.field_70170_p, pos).func_197766_b() || state.func_185904_a() != Material.field_151585_k && state.func_185904_a() != Material.field_151584_j || !fluidState.func_206888_e() || block == Blocks.field_150350_a || this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_175655_b(pos, true);
                    }
                }
            }
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        boolean ancient;
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.func_70681_au().nextInt(7));
        boolean bl = ancient = this.func_70681_au().nextInt(16) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + this.func_70681_au().nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + this.func_70681_au().nextFloat() * 4.0f);
        }
        this.updateAttributes();
        return spawnDataIn;
    }

    public void onWorldSpawn(Random random) {
        boolean ancient;
        this.setVariant(random.nextInt(7));
        boolean bl = ancient = random.nextInt(15) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + random.nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + random.nextFloat() * 4.0f);
        }
        this.updateAttributes();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_ROAR, ANIMATION_SPEAK};
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.SEA_SERPENT_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.SEA_SERPENT_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.SEA_SERPENT_DIE;
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    private void shoot(LivingEntity entity) {
        if (!this.attackDecision) {
            if (!this.func_70090_H()) {
                this.setBreathing(false);
                this.attackDecision = true;
            }
            if (this.isBreathing()) {
                if (this.field_70173_aa % 40 == 0) {
                    this.func_184185_a(IafSoundRegistry.SEA_SERPENT_BREATH, 4.0f, 1.0f);
                }
                if (this.field_70173_aa % 10 == 0) {
                    this.field_70177_z = this.field_70761_aq;
                    float f1 = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float headPosX = f1 + (float)(this.segments[0].func_226277_ct_() + (double)(1.3f * this.getSeaSerpentScale()) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosZ = f2 + (float)(this.segments[0].func_226281_cx_() + (double)(1.3f * this.getSeaSerpentScale()) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosY = f3 + (float)(this.segments[0].func_226278_cu_() + (double)(0.2f * this.getSeaSerpentScale()));
                    double d2 = entity.func_226277_ct_() - (double)headPosX;
                    double d3 = entity.func_226278_cu_() - (double)headPosY;
                    double d4 = entity.func_226281_cx_() - (double)headPosZ;
                    float inaccuracy = 1.0f;
                    EntitySeaSerpentBubbles entitylargefireball = new EntitySeaSerpentBubbles(IafEntityRegistry.SEA_SERPENT_BUBBLES, this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    float size = 0.8f;
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                    }
                    if (!entity.func_70089_S() || entity == null) {
                        this.setBreathing(false);
                        this.attackDecision = this.func_70681_au().nextBoolean();
                    }
                }
            } else {
                this.setBreathing(true);
            }
        }
        this.func_70625_a((Entity)entity, 360.0f, 360.0f);
    }

    public EnumSeaSerpent getEnum() {
        switch (this.getVariant()) {
            default: {
                return EnumSeaSerpent.BLUE;
            }
            case 1: {
                return EnumSeaSerpent.BRONZE;
            }
            case 2: {
                return EnumSeaSerpent.DEEPBLUE;
            }
            case 3: {
                return EnumSeaSerpent.GREEN;
            }
            case 4: {
                return EnumSeaSerpent.PURPLE;
            }
            case 5: {
                return EnumSeaSerpent.RED;
            }
            case 6: 
        }
        return EnumSeaSerpent.TEAL;
    }

    public void func_213352_e(Vector3d vec) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(vec);
        }
    }

    public void func_241847_a(ServerWorld world, LivingEntity entity) {
        this.attackDecision = this.func_70681_au().nextBoolean();
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public int func_82143_as() {
        return 1000;
    }

    public void onJumpHit(LivingEntity target) {
    }

    public boolean shouldUseJumpAttack(LivingEntity attackTarget) {
        return !attackTarget.func_70090_H() || this.isPreyAtSurface();
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76379_h || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || source == DamageSource.field_76371_c || source.func_76347_k() || super.func_180431_b(source);
    }

    public class SwimmingMoveHelper
    extends MovementController {
        private final EntitySeaSerpent dolphin;

        public SwimmingMoveHelper(EntitySeaSerpent dolphinIn) {
            super((MobEntity)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void func_75641_c() {
            if (this.dolphin.func_70090_H()) {
                this.dolphin.func_213317_d(this.dolphin.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.dolphin.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.dolphin.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.dolphin.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.dolphin.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.field_70761_aq = this.dolphin.field_70177_z = this.func_75639_a(this.dolphin.field_70177_z, f, 10.0f);
                    this.dolphin.field_70759_as = this.dolphin.field_70177_z;
                    float f1 = (float)(this.field_75645_e * 3.0);
                    if (this.dolphin.func_70090_H()) {
                        this.dolphin.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.func_213317_d(this.dolphin.func_213322_ci().func_72441_c(0.0, (double)this.dolphin.func_70689_ay() * d1 * 0.6, 0.0));
                        this.dolphin.field_70125_A = this.func_75639_a(this.dolphin.field_70125_A, f2, 1.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        this.dolphin.field_191988_bg = f3 * f1;
                        this.dolphin.field_70701_bs = -f4 * f1;
                    } else {
                        this.dolphin.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.func_70659_e(0.0f);
                this.dolphin.func_184646_p(0.0f);
                this.dolphin.func_70657_f(0.0f);
                this.dolphin.func_191989_p(0.0f);
            }
        }
    }
}

