/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.ai.GhostAICharge;
import com.github.alexthe666.iceandfire.entity.ai.GhostPathNavigator;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IHumanoid;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class EntityGhost
extends MonsterEntity
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IHumanoid,
IBlacklistedFromStatues {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityGhost.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CHARGING = EntityDataManager.func_187226_a(EntityGhost.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DAYTIME_MODE = EntityDataManager.func_187226_a(EntityGhost.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WAS_FROM_CHEST = EntityDataManager.func_187226_a(EntityGhost.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DAYTIME_COUNTER = EntityDataManager.func_187226_a(EntityGhost.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_SCARE;
    public static Animation ANIMATION_HIT;
    private int animationTick;
    private Animation currentAnimation;

    public EntityGhost(EntityType type, World worldIn) {
        super(type, worldIn);
        ANIMATION_SCARE = Animation.create((int)30);
        ANIMATION_HIT = Animation.create((int)10);
        this.field_70765_h = new MoveHelper(this);
    }

    protected ResourceLocation func_184647_J() {
        return this.wasFromChest() ? LootTables.field_186419_a : this.func_200600_R().func_220348_g();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.GHOST_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.GHOST_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.GHOST_DIE;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.ghostMaxHealth).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, IafConfig.ghostAttackStrength).func_233815_a_(Attributes.field_233826_i_, 1.0);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() != Effects.field_76436_u && potioneffectIn.func_188419_a() != Effects.field_82731_v && super.func_70687_e(potioneffectIn);
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source.func_76347_k() || source == DamageSource.field_76368_d || source == DamageSource.field_76367_g || source == DamageSource.field_76369_e || source == DamageSource.field_82729_p || source == DamageSource.field_82728_o || source == DamageSource.field_220302_v;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GhostPathNavigator(this, worldIn);
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING);
    }

    public void setCharging(boolean moving) {
        this.field_70180_af.func_187227_b(CHARGING, (Object)moving);
    }

    public boolean isDaytimeMode() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DAYTIME_MODE);
    }

    public void setDaytimeMode(boolean moving) {
        this.field_70180_af.func_187227_b(IS_DAYTIME_MODE, (Object)moving);
    }

    public boolean wasFromChest() {
        return (Boolean)this.field_70180_af.func_187225_a(WAS_FROM_CHEST);
    }

    public void setFromChest(boolean moving) {
        this.field_70180_af.func_187227_b(WAS_FROM_CHEST, (Object)moving);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new GhostAICharge(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 1.0f){

            public boolean func_75253_b() {
                if (this.field_75334_a != null && this.field_75334_a instanceof PlayerEntity && ((PlayerEntity)this.field_75334_a).func_184812_l_()) {
                    return false;
                }
                return super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6){

            public boolean func_75250_a() {
                this.field_179481_f = 60;
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, false, false, (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_70089_S();
            }
        }));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity) && DragonUtils.isVillager(entity);
            }
        }));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70145_X = true;
        if (!this.field_70170_p.field_72995_K) {
            boolean day;
            boolean bl = day = this.func_204609_dp() && !this.wasFromChest();
            if (day) {
                if (!this.isDaytimeMode()) {
                    this.setAnimation(ANIMATION_SCARE);
                }
                this.setDaytimeMode(true);
            } else {
                this.setDaytimeMode(false);
                this.setDaytimeCounter(0);
            }
            if (this.isDaytimeMode()) {
                this.func_213317_d(Vector3d.field_186680_a);
                this.setDaytimeCounter(this.getDaytimeCounter() + 1);
                if (this.getDaytimeCounter() >= 100) {
                    this.func_82142_c(true);
                }
            } else {
                this.func_82142_c(this.func_70644_a(Effects.field_76441_p));
                this.setDaytimeCounter(0);
            }
        } else if (this.getAnimation() == ANIMATION_SCARE && this.getAnimationTick() == 3 && !this.isHauntedShoppingList() && this.field_70146_Z.nextInt(3) == 0) {
            this.func_184185_a(IafSoundRegistry.GHOST_JUMPSCARE, this.func_70599_aP(), this.func_70647_i());
            if (this.field_70170_p.field_72995_K) {
                IceAndFire.PROXY.spawnParticle("ghost_appearance", this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_145782_y(), 0.0, 0.0);
            }
        }
        if (this.getAnimation() == ANIMATION_HIT && this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) < 1.4 && this.getAnimationTick() >= 4 && this.getAnimationTick() < 6) {
            this.func_184185_a(IafSoundRegistry.GHOST_ATTACK, this.func_70599_aP(), this.func_70647_i());
            this.func_70652_k((Entity)this.func_70638_az());
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean func_175446_cd() {
        return this.isDaytimeMode() || super.func_175446_cd();
    }

    public boolean func_174814_R() {
        return this.isDaytimeMode() || super.func_174814_R();
    }

    protected boolean func_204609_dp() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float f = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof BoatEntity ? new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_()), this.func_226281_cx_()).func_177984_a() : new BlockPos(this.func_226277_ct_(), (double)Math.round(this.func_226278_cu_() + 4.0), this.func_226281_cx_());
            if (f > 0.5f && this.field_70170_p.func_226660_f_(blockpos)) {
                return true;
            }
        }
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack != null && itemstack.func_77973_b() == IafItemRegistry.MANUSCRIPT && !this.isHauntedShoppingList()) {
            this.setColor(-1);
            this.func_184185_a(IafSoundRegistry.BESTIARY_PAGE, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_213352_e(Vector3d vec) {
        if (this.isDaytimeMode()) {
            super.func_213352_e(Vector3d.field_186680_a);
            return;
        }
        super.func_213352_e(vec);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setColor(this.field_70146_Z.nextInt(3));
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.setColor(-1);
        }
        return spawnDataIn;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(CHARGING, (Object)false);
        this.func_184212_Q().func_187214_a(IS_DAYTIME_MODE, (Object)false);
        this.func_184212_Q().func_187214_a(WAS_FROM_CHEST, (Object)false);
        this.func_184212_Q().func_187214_a(DAYTIME_COUNTER, (Object)0);
    }

    public int getColor() {
        return MathHelper.func_76125_a((int)((Integer)this.func_184212_Q().func_187225_a(COLOR)), (int)-1, (int)2);
    }

    public void setColor(int color) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)color);
    }

    public int getDaytimeCounter() {
        return (Integer)this.func_184212_Q().func_187225_a(DAYTIME_COUNTER);
    }

    public void setDaytimeCounter(int counter) {
        this.func_184212_Q().func_187227_b(DAYTIME_COUNTER, (Object)counter);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setColor(compound.func_74762_e("Color"));
        this.setDaytimeMode(compound.func_74767_n("DaytimeMode"));
        this.setDaytimeCounter(compound.func_74762_e("DaytimeCounter"));
        this.setFromChest(compound.func_74767_n("FromChest"));
        super.func_70037_a(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Color", this.getColor());
        compound.func_74757_a("DaytimeMode", this.isDaytimeMode());
        compound.func_74768_a("DaytimeCounter", this.getDaytimeCounter());
        compound.func_74757_a("FromChest", this.wasFromChest());
        super.func_213281_b(compound);
    }

    public boolean isHauntedShoppingList() {
        return this.getColor() == -1;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_SCARE, ANIMATION_HIT};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return false;
    }

    class MoveHelper
    extends MovementController {
        EntityGhost ghost;

        public MoveHelper(EntityGhost ghost) {
            super((MobEntity)ghost);
            this.ghost = ghost;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double edgeLength;
                Vector3d vec3d = new Vector3d(this.func_179917_d() - this.ghost.func_226277_ct_(), this.func_179919_e() - this.ghost.func_226278_cu_(), this.func_179918_f() - this.ghost.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                if (d0 < (edgeLength = this.ghost.func_174813_aQ().func_72320_b())) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.ghost.func_213317_d(this.ghost.func_213322_ci().func_186678_a(0.5));
                } else {
                    this.ghost.func_213317_d(this.ghost.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.5 * 0.05 / d0)));
                    if (this.ghost.func_70638_az() == null) {
                        Vector3d vec3d1 = this.ghost.func_213322_ci();
                        this.ghost.field_70761_aq = this.ghost.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = this.ghost.func_70638_az().func_226277_ct_() - this.ghost.func_226277_ct_();
                        double d5 = this.ghost.func_70638_az().func_226281_cx_() - this.ghost.func_226281_cx_();
                        this.ghost.field_70761_aq = this.ghost.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

