/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDreadBeast;
import com.github.alexthe666.iceandfire.entity.EntityDreadGhoul;
import com.github.alexthe666.iceandfire.entity.EntityDreadLichSkull;
import com.github.alexthe666.iceandfire.entity.EntityDreadMob;
import com.github.alexthe666.iceandfire.entity.EntityDreadScuttler;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.DreadAITargetNonDread;
import com.github.alexthe666.iceandfire.entity.ai.DreadLichAIStrife;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IDreadMob;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityDreadLich
extends EntityDreadMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IRangedAttackMob {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDreadLich.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MINION_COUNT = EntityDataManager.func_187226_a(EntityDreadLich.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_SPAWN = Animation.create((int)40);
    public static Animation ANIMATION_SUMMON = Animation.create((int)15);
    private final DreadLichAIStrife aiArrowAttack = new DreadLichAIStrife(this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((CreatureEntity)this, 1.0, false);
    private int animationTick;
    private Animation currentAnimation;
    private int fireCooldown = 0;
    private int minionCooldown = 0;

    public EntityDreadLich(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public static boolean canLichSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        return reason == SpawnReason.SPAWNER || worldIn.func_180495_p(blockpos).func_215688_a((IBlockReader)worldIn, blockpos, typeIn) && randomIn.nextInt(40) == 0;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (worldIn instanceof IServerWorld && !IafWorldRegistry.isDimensionListedForMobs((IServerWorld)this.field_70170_p)) {
            return false;
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{IDreadMob.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return DragonUtils.canHostilesTarget((Entity)entity);
            }
        }));
        this.field_70715_bh.func_75776_a(3, (Goal)new DreadAITargetNonDread((MobEntity)this, LivingEntity.class, false, new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(LivingEntity entity) {
                return entity instanceof LivingEntity && DragonUtils.canHostilesTarget((Entity)entity);
            }
        }));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, 128.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(MINION_COUNT, (Object)0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAnimation() == ANIMATION_SPAWN && this.getAnimationTick() < 30) {
            BlockState belowBlock = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b());
            if (belowBlock.func_177230_c() != Blocks.field_150350_a) {
                for (int i = 0; i < 5; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, belowBlock), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_174813_aQ().field_72338_b, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02);
                }
            }
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
        }
        if (this.field_70170_p.field_72995_K && this.getAnimation() == ANIMATION_SUMMON) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            IceAndFire.PROXY.spawnParticle("dread_torch", this.func_226277_ct_() + (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() + (double)f2 * 0.6, d0, d1, d2);
            IceAndFire.PROXY.spawnParticle("dread_torch", this.func_226277_ct_() - (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() - (double)f2 * 0.6, d0, d1, d2);
        }
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
        if (this.minionCooldown > 0) {
            --this.minionCooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)IafItemRegistry.LICH_STAFF));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setAnimation(ANIMATION_SPAWN);
        this.func_180481_a(difficultyIn);
        this.setVariant(this.field_70146_Z.nextInt(5));
        this.setCombatTask();
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("MinionCount", this.getMinionCount());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setMinionCount(compound.func_74762_e("MinionCount"));
        this.setCombatTask();
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getMinionCount() {
        return (Integer)this.field_70180_af.func_187225_a(MINION_COUNT);
    }

    public void setMinionCount(int minions) {
        this.field_70180_af.func_187227_b(MINION_COUNT, (Object)minions);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPAWN, ANIMATION_SUMMON};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public boolean shouldFear() {
        return true;
    }

    @Override
    public Entity getCommander() {
        return null;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EquipmentSlotType.MAINHAND) {
            this.setCombatTask();
        }
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((Goal)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_77973_b() == IafItemRegistry.LICH_STAFF) {
                int i = 100;
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        boolean flag = false;
        if (this.getMinionCount() < 5 && this.minionCooldown == 0) {
            this.setAnimation(ANIMATION_SUMMON);
            this.func_184185_a(IafSoundRegistry.DREAD_LICH_SUMMON, this.func_70599_aP(), this.func_70647_i());
            MobEntity minion = this.getRandomNewMinion();
            int x = (int)this.func_226277_ct_() - 5 + this.field_70146_Z.nextInt(10);
            int z = (int)this.func_226281_cx_() - 5 + this.field_70146_Z.nextInt(10);
            double y = this.getHeightFromXZ(x, z);
            minion.func_70012_b((double)x + 0.5, y, (double)z + 0.5, this.field_70177_z, this.field_70125_A);
            minion.func_70624_b(target);
            if (this.field_70170_p instanceof IServerWorld) {
                minion.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
            }
            if (minion instanceof EntityDreadMob) {
                ((EntityDreadMob)minion).setCommanderId(this.func_110124_au());
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)minion);
            }
            this.minionCooldown = 100;
            this.setMinionCount(this.getMinionCount() + 1);
            flag = true;
        }
        if (this.fireCooldown == 0 && !flag) {
            this.func_184609_a(Hand.MAIN_HAND);
            this.func_184185_a(SoundEvents.field_187945_hs, this.func_70599_aP(), this.func_70647_i());
            EntityDreadLichSkull skull = new EntityDreadLichSkull(IafEntityRegistry.DREAD_LICH_SKULL, this.field_70170_p, (LivingEntity)this, 6.0);
            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() * 2.0f) - skull.func_226278_cu_();
            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            skull.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 0.0f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
            this.field_70170_p.func_217376_c((Entity)skull);
            this.fireCooldown = 100;
        }
    }

    private MobEntity getRandomNewMinion() {
        float chance = this.field_70146_Z.nextFloat();
        if (chance > 0.5f) {
            return new EntityDreadThrall(IafEntityRegistry.DREAD_THRALL, this.field_70170_p);
        }
        if (chance > 0.35f) {
            return new EntityDreadGhoul(IafEntityRegistry.DREAD_GHOUL, this.field_70170_p);
        }
        if (chance > 0.15f) {
            return new EntityDreadBeast(IafEntityRegistry.DREAD_BEAST, this.field_70170_p);
        }
        return new EntityDreadScuttler(IafEntityRegistry.DREAD_SCUTTLER, this.field_70170_p);
    }

    private double getHeightFromXZ(int x, int z) {
        BlockPos thisPos = new BlockPos((double)x, this.func_226278_cu_() + 7.0, (double)z);
        while (this.field_70170_p.func_175623_d(thisPos) && thisPos.func_177956_o() > 2) {
            thisPos = thisPos.func_177977_b();
        }
        double height = (double)thisPos.func_177956_o() + 1.0;
        return height;
    }

    @Override
    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.func_184191_r(entityIn);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190032_gu;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_190034_gw;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190033_gv;
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_190035_gx, 0.15f, 1.0f);
    }
}

