/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.datatracker.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.entity.IafDragonFlightManager;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIFleePlayer;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIFollowOwner;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIHurtByTarget;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIRide;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIWatchClosestIgnoreRider;
import com.github.alexthe666.iceandfire.entity.props.MiscEntityProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IDragonFlute;
import com.github.alexthe666.iceandfire.entity.util.IFlapable;
import com.github.alexthe666.iceandfire.entity.util.IFlyingMount;
import com.github.alexthe666.iceandfire.entity.util.IPhasesThroughBlock;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateFlyingCreature;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityAmphithere
extends TameableEntity
implements ISyncMount,
IAnimatedEntity,
IPhasesThroughBlock,
IFlapable,
IDragonFlute,
IFlyingMount {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityAmphithere.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityAmphithere.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FLAP_TICKS = EntityDataManager.func_187226_a(EntityAmphithere.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityAmphithere.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityAmphithere.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_BITE = Animation.create((int)15);
    public static Animation ANIMATION_BITE_RIDER = Animation.create((int)15);
    public static Animation ANIMATION_WING_BLAST = Animation.create((int)30);
    public static Animation ANIMATION_TAIL_WHIP = Animation.create((int)30);
    public static Animation ANIMATION_SPEAK = Animation.create((int)10);
    public float flapProgress;
    public float groundProgress = 0.0f;
    public float sitProgress = 0.0f;
    public float diveProgress = 0.0f;
    @OnlyIn(value=Dist.CLIENT)
    public IFChainBuffer roll_buffer;
    @OnlyIn(value=Dist.CLIENT)
    public IFChainBuffer tail_buffer;
    @OnlyIn(value=Dist.CLIENT)
    public IFChainBuffer pitch_buffer;
    @Nullable
    public BlockPos orbitPos = null;
    public float orbitRadius = 0.0f;
    public boolean isFallen;
    public BlockPos homePos;
    public boolean hasHomePosition = false;
    protected FlightBehavior flightBehavior = FlightBehavior.WANDER;
    protected int ticksCircling = 0;
    private int animationTick;
    private Animation currentAnimation;
    private int flapTicks = 0;
    private int flightCooldown = 0;
    private int ticksFlying = 0;
    private boolean isFlying;
    private boolean changedFlightBehavior = false;
    private int ticksStill = 0;
    private int ridingTime = 0;
    private boolean isSitting;
    private int navigatorType = 0;

    public EntityAmphithere(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        if (worldIn.field_72995_K) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.tail_buffer = new IFChainBuffer();
        }
        this.switchNavigator(0);
    }

    public static BlockPos getPositionRelativetoGround(Entity entity, World world, double x, double z, Random rand) {
        BlockPos pos = new BlockPos(x, entity.func_226278_cu_(), z);
        for (int yDown = 0; yDown < 6 + rand.nextInt(6); ++yDown) {
            if (world.func_175623_d(pos.func_177979_c(yDown))) continue;
            return pos.func_177981_b(yDown);
        }
        return pos;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (worldIn instanceof IServerWorld && !IafWorldRegistry.isDimensionListedForMobs((IServerWorld)this.field_70170_p)) {
            return false;
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    public static boolean canAmphithereSpawnOn(EntityType<EntityAmphithere> parrotIn, IWorld worldIn, SpawnReason reason, BlockPos p_223317_3_, Random random) {
        Block block = worldIn.func_180495_p(p_223317_3_.func_177977_b()).func_177230_c();
        return block.func_203417_a((ITag)BlockTags.field_206952_E) || block == Blocks.field_196658_i || block.func_203417_a((ITag)BlockTags.field_200031_h) || block == Blocks.field_150350_a;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        if (worldIn.func_226668_i_((Entity)this) && !worldIn.func_72953_d(this.func_174813_aQ())) {
            BlockPos blockpos = this.func_233580_cy_();
            if (blockpos.func_177956_o() < worldIn.func_181545_F()) {
                return false;
            }
            BlockState blockstate = worldIn.func_180495_p(blockpos.func_177977_b());
            if (blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_235714_a_((ITag)BlockTags.field_206952_E)) {
                return true;
            }
        }
        return false;
    }

    public static BlockPos getPositionInOrbit(EntityAmphithere entity, World world, BlockPos orbit, Random rand) {
        float possibleOrbitRadius = entity.orbitRadius + 10.0f;
        float radius = 10.0f;
        if (entity.getCommand() == 2) {
            if (entity.func_70902_q() != null) {
                orbit = entity.func_70902_q().func_233580_cy_().func_177981_b(7);
                radius = 5.0f;
            }
        } else if (entity.hasHomePosition) {
            orbit = entity.homePos.func_177981_b(30);
            radius = 30.0f;
        }
        float angle = (float)Math.PI / 180 * possibleOrbitRadius;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos((double)orbit.func_177958_n() + extraX, (double)orbit.func_177956_o(), (double)orbit.func_177952_p() + extraZ);
        entity.orbitRadius = possibleOrbitRadius;
        return radialPos;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public float func_180484_a(BlockPos pos) {
        if (this.isFlying()) {
            if (this.field_70170_p.func_175623_d(pos)) {
                return 10.0f;
            }
            return 0.0f;
        }
        return super.func_180484_a(pos);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151106_aX) {
            if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                this.func_233687_w_(false);
                this.func_146082_f(player);
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_196130_bo && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(5.0f);
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (super.func_230254_b_(player, hand) == ActionResultType.PASS) {
            if (itemstack != null && itemstack.func_77973_b() == IafItemRegistry.DRAGON_STAFF && this.func_152114_e((LivingEntity)player)) {
                if (player.func_225608_bj_()) {
                    BlockPos pos;
                    this.homePos = pos = this.func_233580_cy_();
                    this.hasHomePosition = true;
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("amphithere.command.new_home", new Object[]{this.homePos.func_177958_n(), this.homePos.func_177956_o(), this.homePos.func_177952_p()}), true);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.SUCCESS;
            }
            if (player.func_225608_bj_() && this.func_152114_e((LivingEntity)player)) {
                if (player.func_184586_b(hand).func_190926_b()) {
                    this.setCommand(this.getCommand() + 1);
                    if (this.getCommand() > 2) {
                        this.setCommand(0);
                    }
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("amphithere.command." + this.getCommand()), true);
                    this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.SUCCESS;
            }
            if (!(this.func_70909_n() && !this.func_152114_e((LivingEntity)player) || this.func_70631_g_())) {
                player.func_184220_m((Entity)this);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new DragonAIRide<EntityAmphithere>(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AmphithereAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new AmphithereAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new AmphithereAIFleePlayer(this, 32.0f, 0.8, 1.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new AIFlyWander());
        this.field_70714_bg.func_75776_a(3, (Goal)new AIFlyCircle());
        this.field_70714_bg.func_75776_a(3, (Goal)new AILandWander((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new EntityAIWatchClosestIgnoreRider((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new AmphithereAIHurtByTarget(this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new AmphithereAITargetItems((MobEntity)this, false));
    }

    public boolean isStill() {
        return Math.abs(this.func_213322_ci().field_72450_a) < 0.05 && Math.abs(this.func_213322_ci().field_72449_c) < 0.05;
    }

    protected void switchNavigator(int navigatorType) {
        if (navigatorType == 0) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new ClimberPathNavigator((MobEntity)this, this.field_70170_p);
            this.navigatorType = 0;
        } else if (navigatorType == 1) {
            this.field_70765_h = new FlyMoveHelper(this);
            this.field_70699_by = new PathNavigateFlyingCreature((MobEntity)this, this.field_70170_p);
            this.navigatorType = 1;
        } else {
            this.field_70765_h = new IafDragonFlightManager.PlayerFlightMoveHelper<EntityAmphithere>(this);
            this.field_70699_by = new PathNavigateFlyingCreature((MobEntity)this, this.field_70170_p);
            this.navigatorType = 2;
        }
    }

    public boolean onLeaves() {
        BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b());
        return state.func_177230_c() instanceof LeavesBlock;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (!this.func_70909_n() && this.isFlying() && !this.func_233570_aj_() && source.func_76352_a() && !this.field_70170_p.field_72995_K) {
            this.isFallen = true;
        }
        if (source.func_76346_g() instanceof LivingEntity && source.func_76346_g().func_184223_x((Entity)this) && this.func_70909_n() && this.func_152114_e((LivingEntity)source.func_76346_g())) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger) && this.func_70909_n()) {
            this.field_70177_z = passenger.field_70177_z;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70909_n() && passenger instanceof PlayerEntity && this.getAnimation() == NO_ANIMATION && this.field_70146_Z.nextInt(15) == 0) {
            this.setAnimation(ANIMATION_BITE_RIDER);
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == ANIMATION_BITE_RIDER && this.getAnimationTick() == 6 && !this.func_70909_n()) {
            passenger.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f);
        }
        float pitch_forward = 0.0f;
        pitch_forward = this.field_70125_A > 0.0f && this.isFlying() ? this.field_70125_A / 45.0f * 0.45f : 0.0f;
        float scaled_ground = this.groundProgress * 0.1f;
        float radius = (this.func_70909_n() ? 0.5f : 0.3f) - scaled_ground * 0.5f + pitch_forward;
        float angle = (float)Math.PI / 180 * this.field_70761_aq;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + (double)0.7f - (double)(scaled_ground * 0.14f) + (double)pitch_forward, this.func_226281_cx_() + extraZ);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151106_aX;
    }

    public void func_70636_d() {
        boolean notGrounded;
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if (this.func_70090_H() && this.field_70703_bu) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + 0.1, this.func_213322_ci().field_72449_c);
        }
        if (this.func_70631_g_() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (this.func_70880_s()) {
            this.setFlying(false);
        }
        if (this.func_233685_eM_() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        boolean flapping = this.isFlapping();
        boolean flying = this.isFlying() && this.isOverAir() || this.isOverAir() && !this.onLeaves();
        boolean diving = flying && this.func_213322_ci().field_72448_b <= (double)-0.1f || this.isFallen;
        boolean sitting = this.func_233685_eM_() && !this.isFlying();
        boolean bl = notGrounded = flying || this.getAnimation() == ANIMATION_WING_BLAST;
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_233685_eM_() && (this.getCommand() != 1 || this.func_184179_bs() != null)) {
                this.func_233687_w_(false);
            }
            if (!this.func_233685_eM_() && this.getCommand() == 1 && this.func_184179_bs() == null) {
                this.func_233687_w_(true);
            }
            if (this.func_233685_eM_()) {
                this.func_70661_as().func_75499_g();
            }
            this.ticksFlying = flying ? ++this.ticksFlying : 0;
        }
        if (this.isFlying() && this.field_70122_E) {
            this.setFlying(false);
        }
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        if (this.flightCooldown > 0) {
            --this.flightCooldown;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.ticksCircling = this.flightBehavior == FlightBehavior.CIRCLE ? ++this.ticksCircling : 0;
        }
        if (this.getUntamedRider() != null && !this.func_70909_n()) {
            ++this.ridingTime;
        }
        if (this.getUntamedRider() == null) {
            this.ridingTime = 0;
        }
        if (!this.func_70909_n() && this.ridingTime > IafConfig.amphithereTameTime && this.getUntamedRider() != null && this.getUntamedRider() instanceof PlayerEntity) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)45);
            this.func_193101_c((PlayerEntity)this.getUntamedRider());
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        this.ticksStill = this.isStill() ? ++this.ticksStill : 0;
        if (!this.isFlying() && !this.func_70631_g_() && (this.func_233570_aj_() && this.field_70146_Z.nextInt(200) == 0 && this.flightCooldown == 0 && this.func_184188_bt().isEmpty() && !this.func_175446_cd() && this.canMove() || this.func_226278_cu_() < -1.0)) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + 0.5, this.func_213322_ci().field_72449_c);
            this.setFlying(true);
        }
        if (this.func_184179_bs() != null && this.isFlying() && !this.field_70122_E) {
            this.field_70125_A = this.func_184179_bs().field_70125_A / 2.0f;
            if (this.func_184179_bs().field_70125_A > 25.0f && this.func_213322_ci().field_72448_b > -1.0) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.1, this.func_213322_ci().field_72449_c);
            }
            if (this.func_184179_bs().field_70125_A < -25.0f && this.func_213322_ci().field_72448_b < 1.0) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + 0.1, this.func_213322_ci().field_72449_c);
            }
        }
        if (notGrounded && this.groundProgress > 0.0f) {
            this.groundProgress -= 2.0f;
        } else if (!notGrounded && this.groundProgress < 20.0f) {
            this.groundProgress += 2.0f;
        }
        if (diving && this.diveProgress < 20.0f) {
            this.diveProgress += 1.0f;
        } else if (!diving && this.diveProgress > 0.0f) {
            this.diveProgress -= 1.0f;
        }
        if (this.isFlying()) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + 0.08, this.func_213322_ci().field_72449_c);
        }
        if (this.isFallen && this.flightBehavior != FlightBehavior.NONE) {
            this.flightBehavior = FlightBehavior.NONE;
        }
        if (this.flightBehavior == FlightBehavior.NONE && this.func_184179_bs() == null && this.isFlying()) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.3, this.func_213322_ci().field_72449_c);
        }
        if (this.isFlying() && !this.func_233570_aj_() && this.isFallen && this.func_184179_bs() == null) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.2, this.func_213322_ci().field_72449_c);
            this.field_70125_A = Math.max(this.field_70125_A + 5.0f, 75.0f);
        }
        if (this.isFallen && this.field_70122_E) {
            this.setFlying(false);
            this.flightCooldown = this.func_70909_n() ? 50 : 12000;
            this.isFallen = false;
        }
        if (flying && this.isOverAir()) {
            if (this.getRidingPlayer() == null && this.navigatorType != 1) {
                this.switchNavigator(1);
            }
            if (this.getRidingPlayer() != null && this.navigatorType != 2) {
                this.switchNavigator(2);
            }
        }
        if (!flying && this.navigatorType != 0) {
            this.switchNavigator(0);
        }
        if ((this.hasHomePosition || this.getCommand() == 2) && this.flightBehavior == FlightBehavior.WANDER) {
            this.flightBehavior = FlightBehavior.CIRCLE;
        }
        if (flapping && this.flapProgress < 10.0f) {
            this.flapProgress += 1.0f;
        } else if (!flapping && this.flapProgress > 0.0f) {
            this.flapProgress -= 1.0f;
        }
        if (this.flapTicks > 0) {
            --this.flapTicks;
        }
        this.field_70761_aq = this.field_70177_z;
        if (this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E) {
                this.roll_buffer.calculateChainFlapBuffer(this.func_184207_aI() ? 55.0f : 90.0f, 1, 10.0f, 0.5f, (LivingEntity)this);
                this.pitch_buffer.calculateChainPitchBuffer(90.0f, 10, 10.0f, 0.5f, (LivingEntity)this);
            }
            this.tail_buffer.calculateChainSwingBuffer(70.0f, 20, 5.0f, (LivingEntity)this);
        }
        if (this.changedFlightBehavior) {
            this.changedFlightBehavior = false;
        }
        if (!flapping && (this.func_213322_ci().field_72448_b > (double)0.15f || this.func_213322_ci().field_72448_b > 0.0 && this.field_70173_aa % 200 == 0) && this.isOverAir()) {
            this.flapWings();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @Override
    public boolean isFlapping() {
        return this.flapTicks > 0;
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        if (command == 1) {
            this.func_233687_w_(true);
        } else {
            this.func_233687_w_(false);
        }
    }

    @Override
    public void flapWings() {
        this.flapTicks = 20;
    }

    public boolean func_233685_eM_() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_233687_w_(boolean sitting) {
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity) || this.func_70638_az() == passenger) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            if (!this.func_70909_n() || this.func_184753_b() == null || !this.func_184753_b().equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    @Nullable
    public Entity getUntamedRider() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity)) continue;
            return passenger;
        }
        return null;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.amphithereMaxHealth).func_233815_a_(Attributes.field_233821_d_, 0.4).func_233815_a_(Attributes.field_233823_f_, IafConfig.amphithereAttackStrength).func_233815_a_(Attributes.field_233819_b_, 32.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(FLAP_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74768_a("FlightCooldown", this.flightCooldown);
        compound.func_74768_a("RidingTime", this.ridingTime);
        compound.func_74757_a("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            compound.func_74768_a("HomeAreaX", this.homePos.func_177958_n());
            compound.func_74768_a("HomeAreaY", this.homePos.func_177956_o());
            compound.func_74768_a("HomeAreaZ", this.homePos.func_177952_p());
        }
        compound.func_74768_a("Command", this.getCommand());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.flightCooldown = compound.func_74762_e("FlightCooldown");
        this.ridingTime = compound.func_74762_e("RidingTime");
        this.hasHomePosition = compound.func_74767_n("HasHomePosition");
        if (this.hasHomePosition && compound.func_74762_e("HomeAreaX") != 0 && compound.func_74762_e("HomeAreaY") != 0 && compound.func_74762_e("HomeAreaZ") != 0) {
            this.homePos = new BlockPos(compound.func_74762_e("HomeAreaX"), compound.func_74762_e("HomeAreaY"), compound.func_74762_e("HomeAreaZ"));
        }
        this.setCommand(compound.func_74762_e("Command"));
    }

    public boolean getCanSpawnHere() {
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
        BlockPos blockpos = new BlockPos(i, j, k);
        Block block = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c();
        return this.field_70170_p.func_175710_j(blockpos.func_177984_a());
    }

    public void func_70071_h_() {
        LivingEntity target;
        double dist;
        double dist2;
        super.func_70071_h_();
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 7 && (dist2 = this.func_70068_e((Entity)this.func_70638_az())) < 10.0) {
            this.func_70638_az().func_233627_a_(0.6f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
        }
        if (this.getAnimation() == ANIMATION_WING_BLAST && this.getAnimationTick() == 5) {
            this.func_184185_a(IafSoundRegistry.AMPHITHERE_GUST, 1.0f, 1.0f);
        }
        if ((this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_BITE_RIDER) && this.getAnimationTick() == 1) {
            this.func_184185_a(IafSoundRegistry.AMPHITHERE_BITE, 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_WING_BLAST && this.func_70638_az() != null && this.getAnimationTick() > 5 && this.getAnimationTick() < 22 && (dist = this.func_70068_e((Entity)(target = this.func_70638_az()))) < 25.0) {
            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() / 2));
            target.field_70160_al = true;
            if (!(this.field_70146_Z.nextDouble() < this.func_110148_a(Attributes.field_233820_c_).func_111126_e())) {
                this.field_70160_al = true;
                double d1 = target.func_226277_ct_() - this.func_226277_ct_();
                double d0 = target.func_226281_cx_() - this.func_226281_cx_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                Vector3d Vector3d2 = this.func_213322_ci();
                Vector3d Vector3d1 = new Vector3d(d0, 0.0, d1).func_72432_b().func_186678_a(0.5);
                this.func_213293_j(Vector3d2.field_72450_a / 2.0 - Vector3d1.field_72450_a, this.func_233570_aj_() ? Math.min(0.4, Vector3d2.field_72448_b / 2.0 + 0.5) : Vector3d2.field_72448_b, Vector3d2.field_72449_c / 2.0 - Vector3d1.field_72449_c);
            }
        }
        if (this.getAnimation() == ANIMATION_TAIL_WHIP && this.func_70638_az() != null && this.getAnimationTick() == 7) {
            target = this.func_70638_az();
            dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist < 10.0) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
                this.func_70638_az().field_70160_al = true;
                float f = MathHelper.func_76133_a((double)0.5);
                double d1 = target.func_226277_ct_() - this.func_226277_ct_();
                double d0 = target.func_226281_cx_() - this.func_226281_cx_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                Vector3d Vector3d3 = this.func_213322_ci();
                Vector3d Vector3d1 = new Vector3d(d0, 0.0, d1).func_72432_b().func_186678_a(0.5);
                this.func_213293_j(Vector3d3.field_72450_a / 2.0 - Vector3d1.field_72450_a, this.func_233570_aj_() ? Math.min(0.4, Vector3d3.field_72448_b / 2.0 + 0.5) : Vector3d3.field_72448_b, Vector3d3.field_72449_c / 2.0 - Vector3d1.field_72449_c);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        if (this.isGoingUp() && !this.field_70170_p.field_72995_K && !this.isFlying()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 1.0, 0.0));
            this.setFlying(true);
        }
        if (!this.isOverAir() && this.isFlying() && this.ticksFlying > 25) {
            this.setFlying(false);
        }
        if (this.dismountIAF() && this.isFlying() && this.field_70122_E) {
            this.setFlying(false);
        }
        if (this.getUntamedRider() != null && this.getUntamedRider().func_225608_bj_()) {
            MiscEntityProperties properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(this.getUntamedRider(), MiscEntityProperties.class);
            if (properties != null) {
                properties.hasDismountedDragon = true;
            }
            this.getUntamedRider().func_184210_p();
        }
        if (this.attack() && this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity) {
            target = DragonUtils.riderLookingAtEntity((LivingEntity)this, (LivingEntity)((PlayerEntity)this.func_184179_bs()), 2.5);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
            }
            if (target != null) {
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            }
        }
        if (this.func_70638_az() != null && this.func_152114_e(this.func_70638_az())) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.func_233570_aj_() && this.isFlying() && this.ticksFlying > 40) {
            this.setFlying(false);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_TAIL_WHIP && this.getAnimation() != ANIMATION_WING_BLAST && this.func_184179_bs() == null) {
            if (this.field_70146_Z.nextBoolean()) {
                this.setAnimation(ANIMATION_BITE);
            } else {
                this.setAnimation(this.func_70681_au().nextBoolean() || this.isFlying() ? ANIMATION_WING_BLAST : ANIMATION_TAIL_WHIP);
            }
            return true;
        }
        return false;
    }

    public boolean isRidingPlayer(PlayerEntity player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().func_110124_au().equals(player.func_110124_au());
    }

    @Override
    @Nullable
    public PlayerEntity getRidingPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((PlayerEntity)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.down(IafKeybindRegistry.dragon_down.func_151470_d());
            this.attack(IafKeybindRegistry.dragon_strike.func_151470_d());
            this.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(this.func_145782_y(), controlState, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(this.func_145782_y(), controlState, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
        }
    }

    @Override
    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    @Override
    public boolean isGoingUp() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean isGoingDown() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean dismountIAF() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }

    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    public void dismount(boolean dismount) {
        this.setStateField(3, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.AMPHITHERE_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.AMPHITHERE_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.AMPHITHERE_DIE;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_BITE_RIDER, ANIMATION_WING_BLAST, ANIMATION_TAIL_WHIP, ANIMATION_SPEAK};
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 40;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        EntityAmphithere amphithere = new EntityAmphithere(IafEntityRegistry.AMPHITHERE, this.field_70170_p);
        amphithere.setVariant(this.getVariant());
        return amphithere;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 10;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.func_70681_au().nextInt(5));
        return spawnDataIn;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    @Override
    public boolean canPhaseThroughBlock(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof LeavesBlock;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (!this.canMove() && !this.func_184207_aI()) {
            super.func_213352_e(travelVector.func_216372_d(0.0, 1.0, 0.0));
            return;
        }
        super.func_213352_e(travelVector);
    }

    public boolean canMove() {
        return this.func_184179_bs() == null && this.sitProgress == 0.0f && !this.func_233685_eM_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            this.playEffect();
        } else {
            super.func_70103_a(id);
        }
    }

    protected void playEffect() {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    @Override
    public void onHearFlute(PlayerEntity player) {
        if (!this.func_233570_aj_() && this.func_70909_n()) {
            this.isFallen = true;
        }
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public double getFlightSpeedModifier() {
        return 0.555;
    }

    @Override
    public boolean fliesLikeElytra() {
        return !this.field_70122_E;
    }

    private boolean isOverAir() {
        return this.field_70170_p.func_175623_d(this.func_233580_cy_().func_177977_b());
    }

    public boolean canBlockPosBeSeen(BlockPos pos) {
        Vector3d Vector3d1;
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, Vector3d1 = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    class FlyMoveHelper
    extends MovementController {
        public FlyMoveHelper(EntityAmphithere entity) {
            super((MobEntity)entity);
            this.field_75645_e = 1.75;
        }

        public void func_75641_c() {
            if (!EntityAmphithere.this.canMove()) {
                return;
            }
            if (EntityAmphithere.this.field_70123_F) {
                EntityAmphithere.this.field_70177_z += 180.0f;
                this.field_75645_e = 0.1f;
                BlockPos target = EntityAmphithere.getPositionRelativetoGround((Entity)EntityAmphithere.this, EntityAmphithere.this.field_70170_p, EntityAmphithere.this.func_226277_ct_() + (double)EntityAmphithere.this.field_70146_Z.nextInt(15) - 7.0, EntityAmphithere.this.func_226281_cx_() + (double)EntityAmphithere.this.field_70146_Z.nextInt(15) - 7.0, EntityAmphithere.this.field_70146_Z);
                this.field_75646_b = target.func_177958_n();
                this.field_75647_c = target.func_177956_o();
                this.field_75644_d = target.func_177952_p();
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityAmphithere.this.func_226277_ct_();
                double d1 = this.field_75647_c - EntityAmphithere.this.func_226278_cu_();
                double d2 = this.field_75644_d - EntityAmphithere.this.func_226281_cx_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < 6.0 && EntityAmphithere.this.func_70638_az() == null) {
                    if (!EntityAmphithere.this.changedFlightBehavior && EntityAmphithere.this.flightBehavior == FlightBehavior.WANDER && EntityAmphithere.this.field_70146_Z.nextInt(30) == 0) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.CIRCLE;
                        EntityAmphithere.this.changedFlightBehavior = true;
                    }
                    if (!EntityAmphithere.this.changedFlightBehavior && EntityAmphithere.this.flightBehavior == FlightBehavior.CIRCLE && EntityAmphithere.this.field_70146_Z.nextInt(5) == 0 && EntityAmphithere.this.ticksCircling > 150) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.WANDER;
                        EntityAmphithere.this.changedFlightBehavior = true;
                    }
                    if (EntityAmphithere.this.hasHomePosition && EntityAmphithere.this.flightBehavior != FlightBehavior.NONE || EntityAmphithere.this.getCommand() == 2) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.CIRCLE;
                    }
                }
                if (d3 < 1.0 && EntityAmphithere.this.func_70638_az() == null) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityAmphithere.this.func_213317_d(EntityAmphithere.this.func_213322_ci().func_216372_d(0.5, 0.5, 0.5));
                } else {
                    float f1;
                    EntityAmphithere.this.func_213317_d(EntityAmphithere.this.func_213322_ci().func_72441_c(d0 / d3 * 0.5 * this.field_75645_e, d1 / d3 * 0.5 * this.field_75645_e, d2 / d3 * 0.5 * this.field_75645_e));
                    EntityAmphithere.this.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                    if (EntityAmphithere.this.func_70638_az() == null) {
                        EntityAmphithere.this.field_70761_aq = EntityAmphithere.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityAmphithere.this.func_213322_ci().field_72450_a, (double)EntityAmphithere.this.func_213322_ci().field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = EntityAmphithere.this.func_70638_az().func_226277_ct_() - EntityAmphithere.this.func_226277_ct_();
                        double d5 = EntityAmphithere.this.func_70638_az().func_226281_cx_() - EntityAmphithere.this.func_226281_cx_();
                        EntityAmphithere.this.field_70761_aq = EntityAmphithere.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIFlyCircle
    extends Goal {
        BlockPos target;

        public boolean func_75250_a() {
            if (EntityAmphithere.this.flightBehavior != FlightBehavior.CIRCLE || !EntityAmphithere.this.canMove()) {
                return false;
            }
            if (EntityAmphithere.this.isFlying()) {
                EntityAmphithere.this.orbitPos = EntityAmphithere.getPositionRelativetoGround((Entity)EntityAmphithere.this, EntityAmphithere.this.field_70170_p, EntityAmphithere.this.func_226277_ct_() + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.func_226281_cx_() + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.field_70146_Z);
                this.target = EntityAmphithere.getPositionInOrbit(EntityAmphithere.this, EntityAmphithere.this.field_70170_p, EntityAmphithere.this.orbitPos, EntityAmphithere.this.field_70146_Z);
                return true;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints() {
            return EntityAmphithere.this.canBlockPosBeSeen(this.target);
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            if (!this.isDirectPathBetweenPoints()) {
                this.target = EntityAmphithere.getPositionInOrbit(EntityAmphithere.this, EntityAmphithere.this.field_70170_p, EntityAmphithere.this.orbitPos, EntityAmphithere.this.field_70146_Z);
            }
            if (EntityAmphithere.this.field_70170_p.func_175623_d(this.target)) {
                EntityAmphithere.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntityAmphithere.this.func_70638_az() == null) {
                    EntityAmphithere.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class AIFlyWander
    extends Goal {
        BlockPos target;

        public boolean func_75250_a() {
            if (EntityAmphithere.this.flightBehavior != FlightBehavior.WANDER || !EntityAmphithere.this.canMove()) {
                return false;
            }
            if (EntityAmphithere.this.isFlying()) {
                this.target = EntityAmphithere.getPositionRelativetoGround((Entity)EntityAmphithere.this, EntityAmphithere.this.field_70170_p, EntityAmphithere.this.func_226277_ct_() + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.func_226281_cx_() + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.field_70146_Z);
                EntityAmphithere.this.orbitPos = null;
                return !EntityAmphithere.this.func_70605_aq().func_75640_a() || EntityAmphithere.this.ticksStill >= 50;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints(Entity e) {
            return EntityAmphithere.this.canBlockPosBeSeen(this.target);
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            if (!this.isDirectPathBetweenPoints((Entity)EntityAmphithere.this)) {
                this.target = EntityAmphithere.getPositionRelativetoGround((Entity)EntityAmphithere.this, EntityAmphithere.this.field_70170_p, EntityAmphithere.this.func_226277_ct_() + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.func_226281_cx_() + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.field_70146_Z);
            }
            if (EntityAmphithere.this.field_70170_p.func_175623_d(this.target)) {
                EntityAmphithere.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntityAmphithere.this.func_70638_az() == null) {
                    EntityAmphithere.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class AILandWander
    extends WaterAvoidingRandomWalkingGoal {
        public AILandWander(CreatureEntity creature, double speed) {
            super(creature, speed, 10.0f);
        }

        public boolean func_75250_a() {
            return this.field_75457_a.func_233570_aj_() && super.func_75250_a() && ((EntityAmphithere)this.field_75457_a).canMove();
        }
    }

    public static enum FlightBehavior {
        CIRCLE,
        WANDER,
        NONE;

    }
}

