/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.iceandfire.client.model.ICustomStatueModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;

public abstract class ModelDragonBase<T extends Entity>
extends AdvancedEntityModel<T>
implements ICustomStatueModel {
    private List<AdvancedModelBox> advancedPartList = new ArrayList<AdvancedModelBox>();

    public void rotate(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void rotateMinus(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x) - model.defaultRotationX, (float)Math.toRadians(y) - model.defaultRotationY, (float)Math.toRadians(z) - model.defaultRotationZ);
    }

    public void progressRotationInterp(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ, float max) {
        model.field_78795_f += progress * (rotX - model.defaultRotationX) / max;
        model.field_78796_g += progress * (rotY - model.defaultRotationY) / max;
        model.field_78808_h += progress * (rotZ - model.defaultRotationZ) / max;
    }

    public void progresPositionInterp(AdvancedModelBox model, float progress, float x, float y, float z, float max) {
        model.field_78800_c += progress * x / max;
        model.field_78797_d += progress * y / max;
        model.field_78798_e += progress * z / max;
    }

    public void progressRotation(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ) {
        model.field_78795_f += progress * (rotX - model.defaultRotationX) / 20.0f;
        model.field_78796_g += progress * (rotY - model.defaultRotationY) / 20.0f;
        model.field_78808_h += progress * (rotZ - model.defaultRotationZ) / 20.0f;
    }

    public void progressRotationPrev(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ) {
        model.field_78795_f += progress * rotX / 20.0f;
        model.field_78796_g += progress * rotY / 20.0f;
        model.field_78808_h += progress * rotZ / 20.0f;
    }

    public void progressPosition(AdvancedModelBox model, float progress, float x, float y, float z) {
        model.field_78800_c += progress * (x - model.defaultPositionX) / 20.0f;
        model.field_78797_d += progress * (y - model.defaultPositionY) / 20.0f;
        model.field_78798_e += progress * (z - model.defaultPositionZ) / 20.0f;
    }

    public void progressPositionPrev(AdvancedModelBox model, float progress, float x, float y, float z) {
        model.field_78800_c += progress * x / 20.0f;
        model.field_78797_d += progress * y / 20.0f;
        model.field_78798_e += progress * z / 20.0f;
    }

    public void setRotateAngle(AdvancedModelBox modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void accept(ModelRenderer p_accept_1_) {
        if (p_accept_1_ instanceof AdvancedModelBox) {
            this.advancedPartList.add((AdvancedModelBox)p_accept_1_);
        }
    }

    public void updateDefaultPose() {
        this.advancedPartList.forEach(modelRenderer -> modelRenderer.updateDefaultPose());
    }

    public void resetToDefaultPose() {
        this.advancedPartList.forEach(modelRenderer -> modelRenderer.resetToDefaultPose());
    }
}

