/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.tile;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.util.ModifiableEnergyStorage;

public class SimChamberTileEntity
extends TileEntity
implements ITickableTileEntity {
    protected final SimItemHandler inventory = new SimItemHandler();
    protected final ModifiableEnergyStorage energy = new ModifiableEnergyStorage(HostileConfig.simPowerCap, HostileConfig.simPowerCap);
    protected CachedModel currentModel = null;
    protected int runtime = 0;
    protected boolean predictionSuccess = false;
    protected FailureState failState = FailureState.NONE;
    protected IIntArray references = new IIntArray(){

        public int func_221476_a(int pIndex) {
            switch (pIndex) {
                case 0: {
                    return SimChamberTileEntity.this.runtime;
                }
                case 1: {
                    return SimChamberTileEntity.this.predictionSuccess ? 1 : 0;
                }
                case 2: {
                    return SimChamberTileEntity.this.failState.ordinal();
                }
                case 3: {
                    return SimChamberTileEntity.this.energy.getEnergyStored() & 0xFFFF;
                }
                case 4: {
                    return SimChamberTileEntity.this.energy.getEnergyStored() >> 16;
                }
            }
            return -1;
        }

        public void func_221477_a(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    SimChamberTileEntity.this.runtime = pValue;
                    return;
                }
                case 1: {
                    SimChamberTileEntity.this.predictionSuccess = pValue == 1;
                    return;
                }
                case 2: {
                    SimChamberTileEntity.this.failState = FailureState.values()[pValue];
                    return;
                }
                case 3: {
                    pValue = (short)pValue & 0xFFFF;
                    SimChamberTileEntity.this.energy.setEnergy(SimChamberTileEntity.this.energy.getEnergyStored() & 0xFFFF0000 | pValue);
                    return;
                }
                case 4: {
                    pValue = (short)pValue & 0xFFFF;
                    SimChamberTileEntity.this.energy.setEnergy(SimChamberTileEntity.this.energy.getEnergyStored() & 0xFFFF | pValue << 16);
                    return;
                }
            }
        }

        public int func_221478_a() {
            return 6;
        }
    };

    public SimChamberTileEntity() {
        super(Hostile.TileEntities.SIM_CHAMBER);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        tag.func_74768_a("energy", this.energy.getEnergyStored());
        tag.func_74778_a("model", this.currentModel == null ? "null" : this.currentModel.getModel().getId().toString());
        tag.func_74768_a("runtime", this.runtime);
        tag.func_74757_a("predSuccess", this.predictionSuccess);
        tag.func_74768_a("failState", this.failState.ordinal());
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.energy.setEnergy(tag.func_74762_e("energy"));
        ItemStack model = this.inventory.getStackInSlot(0);
        CachedModel cModel = this.getOrLoadModel(model);
        String modelId = tag.func_74779_i("model");
        if (cModel != null && cModel.getModel().getId().toString().equals(modelId)) {
            this.currentModel = cModel;
        }
        this.runtime = tag.func_74762_e("runtime");
        this.predictionSuccess = tag.func_74767_n("predSuccess");
        this.failState = FailureState.values()[tag.func_74762_e("failState")];
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack model = this.inventory.getStackInSlot(0);
        if (!model.func_190926_b()) {
            CachedModel oldModel = this.currentModel;
            this.currentModel = this.getOrLoadModel(model);
            if (oldModel != this.currentModel) {
                this.runtime = 0;
            }
            if (this.currentModel != null) {
                if (this.currentModel.getTier() == ModelTier.FAULTY) {
                    this.failState = FailureState.FAULTY;
                    this.runtime = 0;
                    return;
                }
                if (this.runtime == 0) {
                    if (this.canStartSimulation()) {
                        this.runtime = 300;
                        this.predictionSuccess = this.field_145850_b.field_73012_v.nextFloat() <= this.currentModel.getAccuracy();
                        this.inventory.getStackInSlot(1).func_190918_g(1);
                    }
                } else if (--this.runtime == 0) {
                    ModelTier tier;
                    ItemStack stk = this.inventory.getStackInSlot(2);
                    if (stk.func_190926_b()) {
                        this.inventory.setStackInSlot(2, this.currentModel.getModel().getBaseDrop().func_77946_l());
                    } else {
                        stk.func_190917_f(1);
                    }
                    if (this.predictionSuccess) {
                        stk = this.inventory.getStackInSlot(3);
                        if (stk.func_190926_b()) {
                            this.inventory.setStackInSlot(3, this.currentModel.getPredictionDrop());
                        } else {
                            stk.func_190917_f(1);
                        }
                    }
                    if ((tier = this.currentModel.getTier()) != tier.next()) {
                        this.currentModel.setData(this.currentModel.getData() + 1);
                    }
                    DataModelItem.setIters(model, DataModelItem.getIters(model) + 1);
                } else if (this.runtime != 0) {
                    this.energy.setEnergy(this.energy.getEnergyStored() - this.currentModel.getModel().getSimCost());
                }
                return;
            }
        }
        this.failState = FailureState.MODEL;
        this.runtime = 0;
    }

    public boolean canStartSimulation() {
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            this.failState = FailureState.INPUT;
            return false;
        }
        DataModel model = this.currentModel.getModel();
        ItemStack nOut = this.inventory.getStackInSlot(2);
        ItemStack pOut = this.inventory.getStackInSlot(3);
        ItemStack nOutExp = model.getBaseDrop();
        ItemStack pOutExp = this.currentModel.getPredictionDrop();
        if (this.canStack(nOut, nOutExp) && this.canStack(pOut, pOutExp)) {
            if (this.hasPowerFor(model)) {
                this.failState = FailureState.NONE;
                return true;
            }
            this.failState = FailureState.ENERGY;
            return false;
        }
        this.failState = FailureState.OUTPUT;
        return false;
    }

    public boolean canStack(ItemStack a, ItemStack b) {
        if (a.func_190926_b()) {
            return true;
        }
        return a.func_77973_b() == b.func_77973_b() && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b) && a.func_190916_E() < a.func_77976_d();
    }

    public boolean hasPowerFor(DataModel model) {
        return this.energy.getEnergyStored() >= model.getSimCost() * 300;
    }

    @Nullable
    protected CachedModel getOrLoadModel(ItemStack stack) {
        if (this.currentModel == null || this.currentModel.getSourceStack() != stack) {
            CachedModel model = new CachedModel(stack, 0);
            if (model.getModel() != null) {
                return model;
            }
            return null;
        }
        return this.currentModel;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energy).cast();
        }
        return super.getCapability(cap, side);
    }

    public SimItemHandler getInventory() {
        return this.inventory;
    }

    public IIntArray getRefHolder() {
        return this.references;
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getRuntime() {
        return this.runtime;
    }

    public boolean didPredictionSucceed() {
        return this.predictionSuccess;
    }

    public FailureState getFailState() {
        return this.failState;
    }

    public static enum FailureState {
        NONE("none"),
        OUTPUT("output"),
        ENERGY("energy"),
        INPUT("input"),
        MODEL("model"),
        FAULTY("faulty");

        private final String name;

        private FailureState(String name) {
            this.name = name;
        }

        public String getKey() {
            return "hostilenetworks.fail." + this.name;
        }
    }

    public class SimItemHandler
    extends ItemStackHandler {
        public SimItemHandler() {
            super(4);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.func_77973_b() instanceof DataModelItem;
            }
            if (slot == 1) {
                return DataModelItem.matchesInput(this.getStackInSlot(0), stack);
            }
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot > 1) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot <= 1) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }
    }
}

