/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.tile;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.hostilenetworks.util.ModifiableEnergyStorage;
import shadows.placebo.recipe.VanillaPacketDispatcher;

public class LootFabTileEntity
extends TileEntity
implements ITickableTileEntity {
    protected final FabItemHandler inventory = new FabItemHandler();
    protected final ModifiableEnergyStorage energy = new ModifiableEnergyStorage(HostileConfig.fabPowerCap, HostileConfig.fabPowerCap);
    protected final Object2IntMap<DataModel> savedSelections = new Object2IntOpenHashMap();
    protected int runtime = 0;
    protected int currentSel = -1;
    protected IIntArray references = new IIntArray(){

        public int func_221476_a(int pIndex) {
            switch (pIndex) {
                case 0: {
                    return LootFabTileEntity.this.runtime;
                }
                case 1: {
                    return LootFabTileEntity.this.energy.getEnergyStored() & 0xFFFF;
                }
                case 2: {
                    return LootFabTileEntity.this.energy.getEnergyStored() >> 16;
                }
            }
            return -1;
        }

        public void func_221477_a(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    LootFabTileEntity.this.runtime = pValue;
                    return;
                }
                case 1: {
                    pValue = (short)pValue & 0xFFFF;
                    LootFabTileEntity.this.energy.setEnergy(LootFabTileEntity.this.energy.getEnergyStored() & 0xFFFF0000 | pValue);
                    return;
                }
                case 2: {
                    pValue = (short)pValue & 0xFFFF;
                    LootFabTileEntity.this.energy.setEnergy(LootFabTileEntity.this.energy.getEnergyStored() & 0xFFFF | pValue << 16);
                    return;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public LootFabTileEntity() {
        super(Hostile.TileEntities.LOOT_FABRICATOR);
        this.savedSelections.defaultReturnValue(-1);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        DataModel dm = MobPredictionItem.getStoredModel(this.inventory.getStackInSlot(0));
        if (dm != null) {
            int selection = this.savedSelections.getInt((Object)dm);
            if (this.currentSel != selection) {
                this.currentSel = selection;
                this.runtime = 0;
                return;
            }
            if (selection != -1) {
                if (this.runtime == 0) {
                    ItemStack out = dm.getFabDrops().get(selection).func_77946_l();
                    if (this.insertInOutput(out, true)) {
                        this.runtime = 60;
                    }
                } else {
                    if (this.energy.getEnergyStored() < HostileConfig.fabPowerCost) {
                        return;
                    }
                    this.energy.setEnergy(this.energy.getEnergyStored() - HostileConfig.fabPowerCost);
                    if (--this.runtime == 0) {
                        this.insertInOutput(dm.getFabDrops().get(selection).func_77946_l(), false);
                        this.inventory.getStackInSlot(0).func_190918_g(1);
                    }
                }
            } else {
                this.runtime = 0;
            }
        } else {
            this.runtime = 0;
        }
    }

    protected boolean insertInOutput(ItemStack stack, boolean sim) {
        for (int i = 1; i < 17; ++i) {
            if (!(stack = this.inventory.insertItemInternal(i, stack, sim)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public IIntArray getRefHolder() {
        return this.references;
    }

    public FabItemHandler getInventory() {
        return this.inventory;
    }

    public void setSelection(DataModel model, int pId) {
        if (pId == -1) {
            this.savedSelections.removeInt((Object)model);
        } else {
            this.savedSelections.put((Object)model, MathHelper.func_76125_a((int)pId, (int)0, (int)(model.getFabDrops().size() - 1)));
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energy).cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a("saved_selections", (INBT)this.writeSelections(new CompoundNBT()));
        tag.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        tag.func_74768_a("energy", this.energy.getEnergyStored());
        tag.func_74768_a("runtime", this.runtime);
        tag.func_74768_a("selection", this.currentSel);
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.readSelections(tag.func_74775_l("saved_selections"));
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.energy.setEnergy(tag.func_74762_e("energy"));
        this.runtime = tag.func_74762_e("runtime");
        this.currentSel = tag.func_74762_e("selection");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("saved_selections", (INBT)this.writeSelections(new CompoundNBT()));
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readSelections(pkt.func_148857_g().func_74775_l("saved_selections"));
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a("saved_selections", (INBT)this.writeSelections(new CompoundNBT()));
        return tag;
    }

    private CompoundNBT writeSelections(CompoundNBT tag) {
        for (Object2IntMap.Entry e : this.savedSelections.object2IntEntrySet()) {
            tag.func_74768_a(((DataModel)e.getKey()).getId().toString(), e.getIntValue());
        }
        return tag;
    }

    private void readSelections(CompoundNBT tag) {
        this.savedSelections.clear();
        for (String s : tag.func_150296_c()) {
            DataModel dm = DataModelManager.INSTANCE.getModel(new ResourceLocation(s));
            this.savedSelections.put((Object)dm, MathHelper.func_76125_a((int)tag.func_74762_e(s), (int)0, (int)(dm.getFabDrops().size() - 1)));
        }
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getRuntime() {
        return this.runtime;
    }

    public int getSelectedDrop(DataModel model) {
        return model == null ? -1 : this.savedSelections.getInt((Object)model);
    }

    public class FabItemHandler
    extends ItemStackHandler {
        public FabItemHandler() {
            super(17);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.func_77973_b() == Hostile.Items.PREDICTION;
            }
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot > 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }

        public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }
    }
}

