/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.gui;

import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.hostilenetworks.tile.LootFabTileEntity;

public class LootFabContainer
extends Container {
    protected final BlockPos pos;
    protected final World level;
    protected final LootFabTileEntity tile;

    public LootFabContainer(int id, PlayerInventory pInv, BlockPos pos) {
        super(Hostile.Containers.LOOT_FABRICATOR, id);
        int row;
        this.pos = pos;
        this.level = pInv.field_70458_d.field_70170_p;
        this.tile = (LootFabTileEntity)this.level.func_175625_s(pos);
        LootFabTileEntity.FabItemHandler inv = this.tile.getInventory();
        this.func_75146_a((Slot)new FilteredSlot(inv, 0, 79, 62, s -> s.func_77973_b() == Hostile.Items.PREDICTION));
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.func_75146_a((Slot)new FilteredSlot(inv, 1 + y * 4 + x, 100 + x * 18, 7 + y * 18, s -> false));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.func_75146_a(new Slot((IInventory)pInv, row, 8 + row * 18, 154));
        }
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)pInv, column + row * 9 + 9, 8 + column * 18, 96 + row * 18));
            }
        }
        this.func_216961_a(this.tile.getRefHolder());
    }

    public boolean func_75145_c(PlayerEntity pPlayer) {
        return pPlayer.field_70170_p.func_180495_p(this.pos).func_177230_c() == Hostile.Blocks.LOOT_FABRICATOR;
    }

    public boolean func_75140_a(PlayerEntity pPlayer, int pId) {
        DataModel model = MobPredictionItem.getStoredModel(this.func_75139_a(0).func_75211_c());
        if (model == null || pId >= model.getFabDrops().size()) {
            return false;
        }
        this.tile.setSelection(model, pId);
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity pPlayer, int pIndex) {
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(pIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            if (pIndex < 17 ? !this.func_75135_a(slotStack, 17, this.field_75151_b.size(), false) : (slotStack.func_77973_b() instanceof MobPredictionItem ? !this.func_75135_a(slotStack, 0, 1, false) : (pIndex < 26 ? !this.func_75135_a(slotStack, 26, this.field_75151_b.size(), false) : !this.func_75135_a(slotStack, 17, 26, false)))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return slotStackCopy;
    }

    public int getEnergyStored() {
        return this.tile.getEnergyStored();
    }

    public int getRuntime() {
        return this.tile.getRuntime();
    }

    public int getSelectedDrop(DataModel model) {
        return this.tile.getSelectedDrop(model);
    }

    protected class FilteredSlot
    extends SlotItemHandler {
        protected final Predicate<ItemStack> filter;
        protected final int field_75222_d;

        public FilteredSlot(LootFabTileEntity.FabItemHandler handler, int index, int x, int y, Predicate<ItemStack> filter) {
            super((IItemHandler)handler, index, x, y);
            this.filter = filter;
            this.field_75222_d = index;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.filter.test(stack);
        }

        public int func_75219_a() {
            return 64;
        }

        public boolean func_82869_a(PlayerEntity playerIn) {
            return true;
        }

        public ItemStack func_75209_a(int amount) {
            return ((LootFabTileEntity.FabItemHandler)this.getItemHandler()).extractItemInternal(this.field_75222_d, amount, false);
        }
    }
}

