/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import shadows.hostilenetworks.HostileNetworks;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.net.DataModelMessage;
import shadows.hostilenetworks.net.DataModelResetMessage;
import shadows.placebo.util.NetworkUtils;
import shadows.placebo.util.json.ItemAdapter;

public class DataModelManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)ItemAdapter.INSTANCE).registerTypeAdapter(DataModel.class, (Object)DataModel.Adapter.INSTANCE).create();
    public static final DataModelManager INSTANCE = new DataModelManager();
    private final Map<ResourceLocation, DataModel> registry = new HashMap<ResourceLocation, DataModel>();
    private final Map<EntityType<?>, DataModel> modelsByType = new HashMap();

    public DataModelManager() {
        super(GSON, "data_models");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, IResourceManager pResourceManager, IProfiler pProfiler) {
        this.clear();
        pObject.forEach((loc, ele) -> {
            try {
                if (ele.getAsJsonObject().entrySet().isEmpty()) {
                    return;
                }
                DataModel model = (DataModel)GSON.fromJson(ele, DataModel.class);
                model.setId((ResourceLocation)loc);
                this.register(model);
            }
            catch (JsonParseException ex) {
                HostileNetworks.LOGGER.error("Failed to load data model {}.", loc);
                ex.printStackTrace();
            }
        });
    }

    public void register(DataModel model) {
        if (this.registry.containsKey(model.id)) {
            throw new UnsupportedOperationException("Attempted to register duplicate data model " + model.id);
        }
        this.registry.put(model.id, model);
        if (this.modelsByType.containsKey(model.type)) {
            String msg = "Attempted to register two models (%s and %s) for Entity Type %s!";
            throw new UnsupportedOperationException(String.format(msg, model.id, this.modelsByType.get(model.type).id, model.type.getRegistryName()));
        }
        this.modelsByType.put(model.type, model);
    }

    @Nullable
    public DataModel getModel(ResourceLocation id) {
        return this.registry.get(id);
    }

    @Nullable
    public DataModel getModel(EntityType<?> type) {
        return this.modelsByType.get(type);
    }

    public Collection<DataModel> getAllModels() {
        return this.registry.values();
    }

    public static void dispatch(PlayerEntity p) {
        if (p.field_70170_p.func_73046_m() != null && p.field_70170_p.func_73046_m().func_71262_S()) {
            NetworkUtils.sendTo((SimpleChannel)HostileNetworks.CHANNEL, (Object)((Object)new DataModelResetMessage()), (PlayerEntity)p);
            for (DataModel dm : DataModelManager.INSTANCE.registry.values()) {
                NetworkUtils.sendTo((SimpleChannel)HostileNetworks.CHANNEL, (Object)((Object)new DataModelMessage(dm)), (PlayerEntity)p);
            }
        }
    }

    public void clear() {
        this.registry.clear();
        this.modelsByType.clear();
    }
}

