/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import shadows.hostilenetworks.HostileClient;
import shadows.hostilenetworks.client.WeirdRenderThings;
import shadows.hostilenetworks.client.WrappedRTBuffer;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.item.DataModelItem;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT}, modid="hostilenetworks")
public class DataModelItemStackRenderer
extends ItemStackTileEntityRenderer {
    private static final IRenderTypeBuffer.Impl GHOST_ENTITY_BUF = IRenderTypeBuffer.func_228455_a_((BufferBuilder)new BufferBuilder(256));
    private static final Map<EntityType<?>, LivingEntity> CACHE = new WeakHashMap();
    private static final ResourceLocation DATA_MODEL_BASE = new ResourceLocation("hostilenetworks", "item/data_model_base");

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType type, MatrixStack matrix, IRenderTypeBuffer buf, int light, int overlay) {
        float scale;
        ItemRenderer irenderer = Minecraft.func_71410_x().func_175599_af();
        IBakedModel base = irenderer.func_175037_a().func_178083_a().getModel(DATA_MODEL_BASE);
        matrix.func_227860_a_();
        if (type == ItemCameraTransforms.TransformType.FIXED) {
            matrix.func_227861_a_(1.0, 1.0, 0.0);
            scale = 0.5f;
            matrix.func_227862_a_(scale, scale, scale);
            matrix.func_227861_a_(-1.5, -0.5, 0.5);
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrix.func_227861_a_(0.0, 0.0, -1.0);
        } else if (type != ItemCameraTransforms.TransformType.GUI) {
            matrix.func_227861_a_(1.0, 1.0, 0.0);
            scale = 0.5f;
            matrix.func_227862_a_(scale, scale, scale);
            matrix.func_227861_a_(-1.5, -0.5, 0.5);
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        } else {
            matrix.func_227861_a_(0.0, -0.5, -0.5);
            matrix.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(75.0f));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(45.0f));
            scale = 0.9f;
            matrix.func_227862_a_(scale, scale, scale);
            matrix.func_227861_a_(0.775, 0.0, -0.0825);
        }
        irenderer.func_229114_a_(base, stack, light, overlay, matrix, ItemRenderer.func_239391_c_((IRenderTypeBuffer)GHOST_ENTITY_BUF, (RenderType)RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)true), (boolean)true, (boolean)false));
        GHOST_ENTITY_BUF.func_228461_a_();
        matrix.func_227865_b_();
        DataModel model = DataModelItem.getStoredModel(stack);
        if (model != null) {
            LivingEntity ent = CACHE.computeIfAbsent(model.getType(), t -> (LivingEntity)t.func_200721_a((World)Minecraft.func_71410_x().field_71441_e));
            if (Minecraft.func_71410_x().field_71439_g != null) {
                ent.field_70173_aa = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
            }
            if (ent != null) {
                this.renderEntityInInventory(matrix, type, ent, model);
            }
        }
    }

    public void renderEntityInInventory(MatrixStack matrix, ItemCameraTransforms.TransformType type, LivingEntity pLivingEntity, DataModel model) {
        float scale;
        RenderSystem.pushMatrix();
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        if (type == ItemCameraTransforms.TransformType.FIXED) {
            matrix.func_227861_a_(0.0, -0.5, 0.0);
            scale = 0.4f;
            matrix.func_227862_a_(scale *= model.getScale(), scale, scale);
            matrix.func_227861_a_(0.0, 1.45, 0.0);
            matrix.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
            matrix.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(180.0f));
        } else if (type == ItemCameraTransforms.TransformType.GUI) {
            matrix.func_227861_a_(0.0, -0.5, 0.0);
            scale = 0.4f;
            matrix.func_227862_a_(scale *= model.getScale(), scale, scale);
            matrix.func_227861_a_(0.0, 0.45, 0.0);
        } else {
            scale = 0.25f;
            matrix.func_227862_a_(scale *= model.getScale(), scale, scale);
            matrix.func_227861_a_(0.0, 0.12 + 0.05 * Math.sin(((float)HostileClient.clientTicks + Minecraft.func_71410_x().func_193989_ak()) / 12.0f), 0.0);
        }
        float rotation = -30.0f;
        if (type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            rotation = 30.0f;
        }
        if (type == ItemCameraTransforms.TransformType.FIXED) {
            rotation = 180.0f;
        }
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        pLivingEntity.field_70761_aq = pLivingEntity.field_70177_z = 0.0f;
        pLivingEntity.field_70759_as = pLivingEntity.field_70177_z;
        pLivingEntity.field_70758_at = pLivingEntity.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl rtBuffer = GHOST_ENTITY_BUF;
        WeirdRenderThings.fullbright = true;
        WeirdRenderThings.translucent = true;
        RenderSystem.runAsFancy(() -> entityrenderermanager.func_229084_a_((Entity)pLivingEntity, (double)model.getXOffset(), (double)model.getYOffset(), (double)model.getZOffset(), 0.0f, Minecraft.func_71410_x().func_193989_ak(), matrix, (IRenderTypeBuffer)new WrappedRTBuffer((IRenderTypeBuffer)rtBuffer), 0xF000F0));
        rtBuffer.func_228461_a_();
        WeirdRenderThings.translucent = false;
        WeirdRenderThings.fullbright = false;
        entityrenderermanager.func_178633_a(true);
        RenderSystem.popMatrix();
        matrix.func_227865_b_();
    }

    @SubscribeEvent
    public static void join(EntityJoinWorldEvent e) {
        if (e.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            CACHE.clear();
        }
    }
}

