/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.block.LootFabBlock;
import shadows.hostilenetworks.block.SimChamberBlock;
import shadows.hostilenetworks.client.DataModelItemStackRenderer;
import shadows.hostilenetworks.gui.DeepLearnerContainer;
import shadows.hostilenetworks.gui.LootFabContainer;
import shadows.hostilenetworks.gui.SimChamberContainer;
import shadows.hostilenetworks.item.BlankDataModelItem;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.item.DeepLearnerItem;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.hostilenetworks.net.DataModelMessage;
import shadows.hostilenetworks.net.DataModelResetMessage;
import shadows.hostilenetworks.tile.LootFabTileEntity;
import shadows.hostilenetworks.tile.SimChamberTileEntity;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.util.NetworkUtils;

@Mod(value="hostilenetworks")
public class HostileNetworks {
    public static final String MODID = "hostilenetworks";
    public static final String VERSION = "1.0.5";
    public static final Logger LOGGER = LogManager.getLogger((String)"hostilenetworks");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("hostilenetworks", "hostilenetworks")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final ItemGroup TAB = new ItemGroup("hostilenetworks"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Hostile.Blocks.SIM_CHAMBER);
        }
    };

    public HostileNetworks() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)0, (NetworkUtils.MessageProvider)new DataModelResetMessage());
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)1, (NetworkUtils.MessageProvider)new DataModelMessage());
        HostileConfig.load();
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register(new SimChamberBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235838_a_(s -> 1).func_200948_a(4.0f, 3000.0f).func_226896_b_()).setRegistryName("sim_chamber"));
        reg.register(new LootFabBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235838_a_(s -> 1).func_200948_a(4.0f, 3000.0f).func_226896_b_()).setRegistryName("loot_fabricator"));
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<TileEntityType<?>> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register(new TileEntityType(SimChamberTileEntity::new, (Set)ImmutableSet.of((Object)Hostile.Blocks.SIM_CHAMBER), null).setRegistryName("sim_chamber"));
        reg.register(new TileEntityType(LootFabTileEntity::new, (Set)ImmutableSet.of((Object)Hostile.Blocks.LOOT_FABRICATOR), null).setRegistryName("loot_fabricator"));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register(new DeepLearnerItem(new Item.Properties().func_200917_a(1).func_200916_a(TAB)).setRegistryName("deep_learner"));
        reg.register(new BlankDataModelItem(new Item.Properties().func_200917_a(1).func_200916_a(TAB)).setRegistryName("blank_data_model"));
        reg.register(new Item(new Item.Properties().func_200916_a(TAB)).setRegistryName("empty_prediction"));
        reg.register(new Item(new Item.Properties().func_200916_a(TAB)).setRegistryName("overworld_prediction"));
        reg.register(new Item(new Item.Properties().func_200916_a(TAB)).setRegistryName("nether_prediction"));
        reg.register(new Item(new Item.Properties().func_200916_a(TAB)).setRegistryName("end_prediction"));
        reg.register(new BlockItem(Hostile.Blocks.SIM_CHAMBER, new Item.Properties().func_200916_a(TAB)).setRegistryName("sim_chamber"));
        reg.register(new BlockItem(Hostile.Blocks.LOOT_FABRICATOR, new Item.Properties().func_200916_a(TAB)).setRegistryName("loot_fabricator"));
        reg.register(new DataModelItem(new Item.Properties().func_200917_a(1).func_200916_a(TAB).setISTER(() -> DataModelItemStackRenderer::new)).setRegistryName("data_model"));
        reg.register(new MobPredictionItem(new Item.Properties().func_200916_a(TAB)).setRegistryName("prediction"));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<ContainerType<?>> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register(new ContainerType((ContainerType.IFactory)((IContainerFactory)(id, inv, buf) -> new DeepLearnerContainer(id, inv, buf.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND))).setRegistryName("deep_learner"));
        reg.register(new ContainerType((ContainerType.IFactory)((IContainerFactory)(id, inv, buf) -> new SimChamberContainer(id, inv, buf.func_179259_c()))).setRegistryName("sim_chamber"));
        reg.register(new ContainerType((ContainerType.IFactory)((IContainerFactory)(id, inv, buf) -> new LootFabContainer(id, inv, buf.func_179259_c()))).setRegistryName("loot_fabricator"));
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        LootSystem.defaultBlockTable((Block)Hostile.Blocks.LOOT_FABRICATOR);
        LootSystem.defaultBlockTable((Block)Hostile.Blocks.SIM_CHAMBER);
    }
}

