/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import me.ichun.mods.hats.client.entity.EntityDummy;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.client.layer.LayerHat;
import me.ichun.mods.hats.client.model.ModelRendererDragonHook;
import me.ichun.mods.hats.client.toast.Toast;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.item.ItemHatLauncher;
import me.ichun.mods.hats.common.packet.PacketRequestEntityHatDetails;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.client.key.KeyBind;
import me.ichun.mods.ichunutil.client.tracker.ClientEntityTracker;
import me.ichun.mods.ichunutil.client.tracker.entity.EntityTracker;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.item.DualHandedItem;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandlerClient {
    public KeyBind keyBindHats;
    public boolean serverHasMod;
    public int renderCount;
    public ArrayList<Integer> requestedHats = new ArrayList();
    public HatsSavedData.PlayerHatData hatsInventory;
    public EntityTracker renderViewEntity;
    public boolean openedHatsInventory;
    public int openMenuAnimation;
    public boolean lastHideGui;
    public float originalPitch;
    public float guiX;
    public float guiY;
    public float guiYaw;
    public float guiPitch;
    public float guiDist;
    public boolean forceRenderWhenInvisible;
    private boolean shownSyncToast;

    @SubscribeEvent
    public void onClientConnection(ClientPlayerNetworkEvent.LoggedInEvent event) {
        this.serverHasMod = false;
        this.resetSyncToast();
    }

    @SubscribeEvent
    public void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.serverHasMod = false;
        this.requestedHats.clear();
        this.hatsInventory = null;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                if (mc.field_71439_g.field_70173_aa == 100 && !this.serverHasMod) {
                    mc.func_193033_an().func_192988_a((IToast)new Toast((ITextComponent)new TranslationTextComponent("hats.toast.clientOnly.title"), (ITextComponent)new TranslationTextComponent("hats.toast.clientOnly.subtitle"), 2));
                }
                if (!this.requestedHats.isEmpty()) {
                    Hats.channel.sendToServer((AbstractPacket)new PacketRequestEntityHatDetails(this.requestedHats.toArray(new Integer[0])));
                    this.requestedHats.clear();
                }
            }
            if (this.openedHatsInventory) {
                if (this.openMenuAnimation < Hats.configClient.guiAnimationTime) {
                    ++this.openMenuAnimation;
                }
                this.openedHatsInventory = mc.field_71462_r instanceof WorkspaceHats;
            } else if (this.openMenuAnimation > 0) {
                --this.openMenuAnimation;
                if (mc.field_71462_r instanceof IngameMenuScreen) {
                    this.openMenuAnimation = 0;
                }
                if (this.openMenuAnimation <= 0) {
                    this.renderViewEntity = null;
                    mc.field_71474_y.field_74319_N = this.lastHideGui;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            this.renderCount = 0;
            if (this.renderViewEntity != null) {
                mc.field_175622_Z = this.renderViewEntity;
                Entity oriRend = this.renderViewEntity.parent;
                double progLinear = MathHelper.func_76131_a((float)(((float)this.openMenuAnimation + (this.openedHatsInventory ? event.renderTickTime : -event.renderTickTime)) / (float)Hats.configClient.guiAnimationTime), (float)0.0f, (float)1.0f);
                double progPowHalf = Math.pow(progLinear, 0.5);
                double progSq = Math.pow(progLinear, 2.0);
                double progSin = Math.sin(Math.toRadians(progLinear * 90.0));
                oriRend.field_70127_C = oriRend.field_70125_A = (float)((double)this.originalPitch + (double)(-this.originalPitch) * progSin);
                float yawCam = (float)((double)(-160.0f + this.guiYaw) * progSin);
                float pitchCam = (float)((double)(-(oriRend.field_70125_A + oriRend.field_70125_A) + this.guiPitch) * progSin);
                if (mc.field_71474_y.func_243230_g().func_243193_b()) {
                    yawCam += (float)(180.0 * progSin);
                }
                float yawFromPlayer = oriRend.field_70177_z + yawCam;
                if (!mc.field_71474_y.func_243230_g().func_243193_b()) {
                    yawFromPlayer += 180.0f;
                }
                float pitchFromPlayer = -(oriRend.field_70125_A + pitchCam);
                Vector3d revLookVec = EntityHelper.getVectorForRotation((float)pitchFromPlayer, (float)yawFromPlayer);
                double dist = (1.4 + (double)this.guiDist) * progPowHalf;
                if (!mc.field_71474_y.func_243230_g().func_243192_a()) {
                    dist -= 4.0 * progSin;
                }
                double upOff = 0.25 + (double)this.guiY;
                Vector3d sideVec = EntityHelper.getVectorForRotation((float)oriRend.field_70125_A, (float)(yawFromPlayer - 90.0f));
                double sideOff = ((1.4 + (double)this.guiDist) * progPowHalf * 0.57 + (double)this.guiX) * (double)((float)mc.func_228018_at_().func_198105_m() / (float)mc.func_228018_at_().func_198083_n()) / 1.7777777910232544;
                double offX = sideOff * sideVec.func_82615_a() * progSq;
                double offY = upOff * progSin + sideOff * sideVec.func_82617_b() * progSq;
                double offZ = sideOff * sideVec.func_82616_c() * progSq;
                Vector3d rendEyePos = oriRend.func_174824_e(event.renderTickTime);
                RayTraceResult camPoint = EntityHelper.rayTrace((World)oriRend.func_130014_f_(), (Vector3d)rendEyePos, (Vector3d)rendEyePos.func_178787_e(revLookVec.func_216372_d(dist, dist, dist)).func_72441_c(offX, offY, offZ), (Entity)oriRend, (boolean)false, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, b -> true, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE, e -> true);
                if (camPoint.func_216346_c() != RayTraceResult.Type.MISS) {
                    Vector3d difference = camPoint.func_216347_e().func_178788_d(rendEyePos).func_72432_b().func_216372_d(0.2, 0.2, 0.2);
                    this.renderViewEntity.func_226286_f_(camPoint.func_216347_e().func_82615_a() - difference.func_82615_a(), camPoint.func_216347_e().func_82617_b() - (double)oriRend.func_70047_e() - difference.func_82617_b(), camPoint.func_216347_e().func_82616_c() - difference.func_82616_c());
                } else {
                    this.renderViewEntity.func_226286_f_(camPoint.func_216347_e().func_82615_a(), camPoint.func_216347_e().func_82617_b() - (double)oriRend.func_70047_e(), camPoint.func_216347_e().func_82616_c());
                }
                this.renderViewEntity.field_70126_B = this.renderViewEntity.field_70177_z = oriRend.field_70177_z + yawCam;
                this.renderViewEntity.field_70127_C = this.renderViewEntity.field_70125_A = oriRend.field_70125_A + pitchCam;
            }
        } else if (this.renderViewEntity != null) {
            this.renderViewEntity.parent.field_70127_C = this.renderViewEntity.parent.field_70125_A = this.originalPitch;
            mc.field_175622_Z = this.renderViewEntity.parent;
        }
    }

    public void openHatsMenu() {
        if (this.serverHasMod && Hats.configServer.enabledGuiStyle <= 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null) {
            boolean fallback;
            if (!mc.field_71439_g.func_70089_S() || mc.field_71439_g.func_70608_bn()) {
                return;
            }
            boolean bl = fallback = Hats.configClient.forceGuiFallback || this.serverHasMod && Hats.configServer.enabledGuiStyle == 1 || mc.field_71439_g.func_213283_Z() != Pose.STANDING && mc.field_71439_g.func_213283_Z() != Pose.CROUCHING || mc.field_71439_g != mc.field_175622_Z || Screen.func_231172_r_() || mc.field_71439_g.func_82150_aj();
            if (!fallback) {
                float yawFromPlayer = mc.field_175622_Z.field_70177_z - 160.0f;
                if (!mc.field_71474_y.func_243230_g().func_243193_b()) {
                    yawFromPlayer += 180.0f;
                }
                float pitchFromPlayer = 0.0f;
                Vector3d revLookVec = EntityHelper.getVectorForRotation((float)pitchFromPlayer, (float)yawFromPlayer);
                double dist = 1.4;
                Vector3d upHeadVec = EntityHelper.getVectorForRotation((float)(mc.field_175622_Z.field_70125_A - 90.0f), (float)mc.field_175622_Z.field_70177_z);
                double upOff = 0.25;
                Vector3d sideVec = EntityHelper.getVectorForRotation((float)mc.field_175622_Z.field_70125_A, (float)(yawFromPlayer - 90.0f));
                double sideOff = 0.75 * (double)((float)mc.func_228018_at_().func_198105_m() / (float)mc.func_228018_at_().func_198083_n()) / 1.7777777910232544;
                double offX = upOff * upHeadVec.func_82615_a() + sideOff * sideVec.func_82615_a();
                double offY = upOff * upHeadVec.func_82617_b() + sideOff * sideVec.func_82617_b();
                double offZ = upOff * upHeadVec.func_82616_c() + sideOff * sideVec.func_82616_c();
                RayTraceResult camPoint = EntityHelper.rayTrace((World)mc.field_175622_Z.func_130014_f_(), (Vector3d)mc.field_175622_Z.func_174824_e(1.0f), (Vector3d)mc.field_175622_Z.func_174824_e(1.0f).func_178787_e(revLookVec.func_216372_d(dist, dist, dist)).func_72441_c(offX, offY, offZ), (Entity)mc.field_175622_Z, (boolean)false, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, b -> true, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE, e -> true);
                fallback = !camPoint.func_216346_c().equals((Object)RayTraceResult.Type.MISS);
            }
            mc.func_147108_a((Screen)new WorkspaceHats(mc.field_71462_r, fallback, (LivingEntity)mc.field_71439_g, null));
            if (!fallback) {
                this.guiDist = 0.0f;
                this.guiPitch = 0.0f;
                this.guiYaw = 0.0f;
                this.guiY = 0.0f;
                this.guiX = 0.0f;
                this.openedHatsInventory = true;
                this.openMenuAnimation = 0;
                this.lastHideGui = mc.field_71474_y.field_74319_N;
                mc.field_71474_y.field_74319_N = true;
                this.originalPitch = mc.field_175622_Z.field_70125_A;
                this.renderViewEntity = EntityDummy.create((World)mc.field_71441_e, mc.field_175622_Z);
                this.renderViewEntity.setParent(mc.field_175622_Z);
                this.renderViewEntity.func_145769_d(ClientEntityTracker.getNextEntId());
                this.renderViewEntity.func_70012_b(mc.field_175622_Z.func_226277_ct_(), mc.field_175622_Z.func_226278_cu_(), mc.field_175622_Z.func_226281_cx_() - 2.0, mc.field_175622_Z.field_70177_z, mc.field_175622_Z.field_70125_A);
                this.renderViewEntity.field_70127_C = this.renderViewEntity.field_70125_A;
                this.renderViewEntity.field_70126_B = this.renderViewEntity.field_70177_z;
            }
        }
    }

    public void requestHatDetails(LivingEntity ent) {
        if (this.serverHasMod) {
            this.requestedHats.add(ent.func_145782_y());
        }
    }

    public void updateHatInventory(HatsSavedData.HatPart hatPart) {
        if (this.hatsInventory == null) {
            Hats.LOGGER.error("We're updating our hats inventory without an inventory!");
            Thread.dumpStack();
            return;
        }
        boolean added = false;
        for (int i = this.hatsInventory.hatParts.size() - 1; i >= 0; --i) {
            HatsSavedData.HatPart part = this.hatsInventory.hatParts.get(i);
            if (!part.name.equals(hatPart.name)) continue;
            this.hatsInventory.hatParts.remove(i);
            this.hatsInventory.hatParts.add(i, hatPart);
            added = true;
            break;
        }
        if (!added) {
            this.hatsInventory.hatParts.add(hatPart);
        }
        Collections.sort(this.hatsInventory.hatParts);
    }

    public void addLayers() {
        LayerHat layerHat = new LayerHat();
        HashSet addedRenderers = new HashSet();
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        Map skinMap = renderManager.getSkinMap();
        for (Map.Entry e : skinMap.entrySet()) {
            ((PlayerRenderer)e.getValue()).func_177094_a(layerHat);
            addedRenderers.add(e.getValue());
        }
        renderManager.field_78729_o.forEach((entityType, entityRenderer) -> {
            if (addedRenderers.contains(entityRenderer)) {
                return;
            }
            if (entityRenderer instanceof LivingRenderer) {
                LivingRenderer renderer = (LivingRenderer)entityRenderer;
                renderer.func_177094_a((LayerRenderer)layerHat);
            } else if (entityRenderer instanceof EnderDragonRenderer) {
                EnderDragonRenderer dragonRenderer = (EnderDragonRenderer)entityRenderer;
                dragonRenderer.field_229058_m_.field_78221_a.func_78792_a((ModelRenderer)new ModelRendererDragonHook(dragonRenderer.field_229058_m_));
            }
        });
    }

    public void nudgeHand(PlayerEntity player) {
        ItemStack is;
        Minecraft mc = Minecraft.func_71410_x();
        if (player == mc.field_71439_g && (is = DualHandedItem.getUsableDualHandedItem((LivingEntity)player)).func_77973_b() instanceof ItemHatLauncher) {
            mc.field_71439_g.field_71155_g -= 200.0f;
            if (!mc.field_71474_y.func_243230_g().func_243192_a()) {
                mc.field_71439_g.func_226292_a_(mc.field_71439_g.func_184591_cq() == DualHandedItem.getHandSide((LivingEntity)mc.field_71439_g, (ItemStack)is) ? Hand.MAIN_HAND : Hand.OFF_HAND, true);
            }
        }
    }

    public void showSyncToast() {
        if (!this.shownSyncToast) {
            this.shownSyncToast = true;
            Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new Toast((ITextComponent)new TranslationTextComponent("hats.toast.sync.title"), (ITextComponent)new TranslationTextComponent("hats.toast.sync.subtitle"), 2));
        }
    }

    public void resetSyncToast() {
        this.shownSyncToast = false;
    }
}

