/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import java.util.ArrayList;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.client.toast.NewHatPartToast;
import me.ichun.mods.hats.client.toast.Toast;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketNewHatPart
extends AbstractPacket {
    public boolean newHat;
    public HatsSavedData.HatPart details;
    public ArrayList<String> names;

    public PacketNewHatPart() {
    }

    public PacketNewHatPart(boolean newHat, HatsSavedData.HatPart details, ArrayList<String> names) {
        this.newHat = newHat;
        this.details = details;
        this.names = names;
    }

    public void writeTo(PacketBuffer buf) {
        buf.writeBoolean(this.newHat);
        buf.func_150786_a(this.details.write(new CompoundNBT()));
        buf.writeInt(this.names.size());
        for (String name : this.names) {
            buf.func_180714_a(name);
        }
    }

    public void readFrom(PacketBuffer buf) {
        this.newHat = buf.readBoolean();
        HatsSavedData.HatPart part = new HatsSavedData.HatPart();
        part.read(buf.func_150793_b());
        this.details = part;
        this.names = new ArrayList();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.names.add(this.readString(buf));
        }
    }

    public void process(NetworkEvent.Context context) {
        context.enqueueWork(this::handleClient);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        if (Hats.configClient.newHatToast) {
            if (!Hats.configClient.shownTutorial && !(Minecraft.func_71410_x().field_71462_r instanceof WorkspaceHats)) {
                Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new Toast((ITextComponent)new TranslationTextComponent("hats.gui.tutorial.toast.title"), (ITextComponent)new TranslationTextComponent("hats.gui.tutorial.toast.subtitle", new Object[]{Hats.eventHandlerClient.keyBindHats.keyBinding.func_238171_j_()}), 0));
            }
            Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new NewHatPartToast(this.details, this.newHat, this.names));
        }
    }
}

