/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.hats.sort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.ichun.mods.hats.common.hats.sort.FilterContributor;
import me.ichun.mods.hats.common.hats.sort.FilterHas;
import me.ichun.mods.hats.common.hats.sort.FilterHasAccessories;
import me.ichun.mods.hats.common.hats.sort.FilterNotFavourite;
import me.ichun.mods.hats.common.hats.sort.FilterUndiscovered;
import me.ichun.mods.hats.common.hats.sort.HatSorter;
import me.ichun.mods.hats.common.hats.sort.SorterAlphabetical;
import me.ichun.mods.hats.common.hats.sort.SorterCount;
import me.ichun.mods.hats.common.hats.sort.SorterDiscovered;
import me.ichun.mods.hats.common.hats.sort.SorterFavourite;
import me.ichun.mods.hats.common.hats.sort.SorterRarity;
import me.ichun.mods.hats.common.world.HatsSavedData;

public class SortHandler {
    public static HashMap<String, Class<? extends HatSorter>> SORTERS = new HashMap<String, Class<? extends HatSorter>>(){
        {
            this.put("filterContributor", FilterContributor.class);
            this.put("filterHas", FilterHas.class);
            this.put("filterHasAccessories", FilterHasAccessories.class);
            this.put("filterNotFavourite", FilterNotFavourite.class);
            this.put("filterUndiscovered", FilterUndiscovered.class);
            this.put("sorterAlphabetical", SorterAlphabetical.class);
            this.put("sorterCount", SorterCount.class);
            this.put("sorterDiscovered", SorterDiscovered.class);
            this.put("sorterFavourite", SorterFavourite.class);
            this.put("sorterRarity", SorterRarity.class);
        }
    };

    public static void sort(ArrayList<HatSorter> sorters, List<?> hats, boolean allowFilter) {
        for (HatSorter sorter : sorters) {
            if (!allowFilter && sorter.isFilter()) continue;
            sorter.sortRecursive(hats);
        }
        ArrayList<HatsSavedData.HatPart> newHats = new ArrayList<HatsSavedData.HatPart>();
        SortHandler.digForHats(newHats, hats);
        hats.clear();
        hats.addAll(newHats);
    }

    private static void digForHats(ArrayList<HatsSavedData.HatPart> finalHatList, List<?> listOfHats) {
        for (Object listOfHat : listOfHats) {
            if (listOfHat instanceof List) {
                SortHandler.digForHats(finalHatList, (List)listOfHat);
                continue;
            }
            if (!(listOfHat instanceof HatsSavedData.HatPart)) continue;
            finalHatList.add((HatsSavedData.HatPart)listOfHat);
        }
    }
}

