/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.handles.misc;

import com.vandendaelen.handles.blocks.tiles.TardisInterfaceTile;
import com.vandendaelen.handles.config.HandlesConfig;
import com.vandendaelen.handles.exceptions.NoUpgradeException;
import com.vandendaelen.handles.functions.FunctionsHandler;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TardisInterfacePeripheral
implements IDynamicPeripheral {
    private final TardisInterfaceTile tile;

    public TardisInterfacePeripheral(TardisInterfaceTile tile) {
        this.tile = tile;
    }

    @Nonnull
    public String getType() {
        return "tardisinterface";
    }

    @Nonnull
    public String[] getMethodNames() {
        return FunctionsHandler.getFunctionsNames();
    }

    @Nullable
    public MethodResult callMethod(IComputerAccess computer, ILuaContext context, int method, IArguments arguments) throws LuaException {
        try {
            if (this.tile.getFunctionsHandler() != null && this.tile.canBeUsed()) {
                String functionName = FunctionsHandler.getFunctionsNames()[method];
                this.tile.damageUpgrade(HandlesConfig.Common.getDamage(functionName));
                return this.tile.getFunctionsHandler().run(functionName, arguments);
            }
            throw new LuaException(new NoUpgradeException().getMessage());
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Nonnull
    public Object getTarget() {
        return this.tile;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other || other instanceof TardisInterfacePeripheral && ((TardisInterfacePeripheral)other).tile == this.tile;
    }

    public static class HandlesTaskCallback
    implements ILuaCallback {
        private final MethodResult pull = MethodResult.pullEvent((String)"task_complete", (ILuaCallback)this);
        private final long task;

        private HandlesTaskCallback(long task) {
            this.task = task;
        }

        @Nonnull
        public MethodResult resume(Object[] response) throws LuaException {
            if (response.length >= 3 && response[1] instanceof Number && response[2] instanceof Boolean) {
                if (((Number)response[1]).longValue() != this.task) {
                    return this.pull;
                }
                if (((Boolean)response[2]).booleanValue()) {
                    return MethodResult.of((Object[])Arrays.copyOfRange(response, 3, response.length));
                }
                if (response.length >= 4 && response[3] instanceof String) {
                    throw new LuaException((String)response[3]);
                }
                throw new LuaException("error");
            }
            return this.pull;
        }
    }
}

