/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.handles.helpers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.tardis.mod.helper.WorldHelper;

public class DimensionHelper {
    public static RegistryKey<World> getDimension(int id) {
        return DimensionHelper.getTardisableDimensionList().get(id);
    }

    public static ArrayList<String> getPrettyDimensionList() {
        ArrayList<RegistryKey<World>> dimensions = DimensionHelper.getTardisableDimensionList();
        return (ArrayList)dimensions.stream().map(dim -> MessageFormat.format("{0} - {1}", DimensionHelper.getDimensionId((RegistryKey<World>)dim), dim.func_240901_a_().toString())).collect(Collectors.toList());
    }

    public static ArrayList<RegistryKey<World>> getTardisableDimensionList() {
        ArrayList<RegistryKey<World>> list = new ArrayList<RegistryKey<World>>();
        for (World world : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
            if (!WorldHelper.canTravelToDimension((World)world)) continue;
            list.add((RegistryKey<World>)world.func_234923_W_());
        }
        return list;
    }

    public static int getDimensionId(RegistryKey<World> dim) {
        ArrayList<RegistryKey<World>> dimensions = DimensionHelper.getTardisableDimensionList();
        return dimensions.indexOf(dim);
    }
}

