/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.handles.functions;

import com.vandendaelen.handles.config.HandlesConfig;
import com.vandendaelen.handles.functions.IFunction;
import com.vandendaelen.handles.functions.handles.GetAlarm;
import com.vandendaelen.handles.functions.handles.GetArtronBank;
import com.vandendaelen.handles.functions.handles.GetCurrentDimension;
import com.vandendaelen.handles.functions.handles.GetDestinationDimension;
import com.vandendaelen.handles.functions.handles.GetDimensions;
import com.vandendaelen.handles.functions.handles.GetHandbrake;
import com.vandendaelen.handles.functions.handles.GetLifeSigns;
import com.vandendaelen.handles.functions.handles.GetRefuel;
import com.vandendaelen.handles.functions.handles.GetSpeed;
import com.vandendaelen.handles.functions.handles.GetSubSystemHealth;
import com.vandendaelen.handles.functions.handles.GetSubSystemStatus;
import com.vandendaelen.handles.functions.handles.GetSubSystems;
import com.vandendaelen.handles.functions.handles.GetTardisDestination;
import com.vandendaelen.handles.functions.handles.GetTardisDoors;
import com.vandendaelen.handles.functions.handles.GetTardisFacing;
import com.vandendaelen.handles.functions.handles.GetTardisLocation;
import com.vandendaelen.handles.functions.handles.GetTimeLeft;
import com.vandendaelen.handles.functions.handles.GetUpgradeHealth;
import com.vandendaelen.handles.functions.handles.GetUpgradeStatus;
import com.vandendaelen.handles.functions.handles.GetUpgrades;
import com.vandendaelen.handles.functions.handles.SetAlarm;
import com.vandendaelen.handles.functions.handles.SetDestinationAndDimension;
import com.vandendaelen.handles.functions.handles.SetDimension;
import com.vandendaelen.handles.functions.handles.SetFlight;
import com.vandendaelen.handles.functions.handles.SetHandbrake;
import com.vandendaelen.handles.functions.handles.SetRefuel;
import com.vandendaelen.handles.functions.handles.SetSpeed;
import com.vandendaelen.handles.functions.handles.SetSubSystemStatus;
import com.vandendaelen.handles.functions.handles.SetTardisDestination;
import com.vandendaelen.handles.functions.handles.SetTardisDoors;
import com.vandendaelen.handles.functions.handles.SetTardisFacing;
import com.vandendaelen.handles.functions.handles.SetUpgradeStatus;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.tardis.mod.tileentities.ConsoleTile;

public class FunctionsHandler {
    private static HashMap<String, IFunction> functions = new HashMap();
    private ConsoleTile tardis;

    public FunctionsHandler(ConsoleTile tardis) {
        this.tardis = tardis;
    }

    public static void init() {
        FunctionsHandler.registerAll(new GetArtronBank(), new GetCurrentDimension(), new GetDestinationDimension(), new GetDimensions(), new GetTardisDestination(), new GetTardisDoors(), new GetTardisFacing(), new GetTardisLocation(), new GetTimeLeft(), new SetTardisDestination(), new SetDimension(), new GetRefuel(), new SetRefuel(), new SetTardisDoors(), new SetTardisFacing(), new SetFlight(), new GetLifeSigns(), new GetHandbrake(), new SetHandbrake(), new SetSpeed(), new GetSpeed(), new GetAlarm(), new SetAlarm(), new SetDestinationAndDimension(), new GetSubSystems(), new GetSubSystemStatus(), new GetSubSystemHealth(), new SetSubSystemStatus(), new GetUpgrades(), new GetUpgradeHealth(), new GetUpgradeStatus(), new SetUpgradeStatus());
    }

    public static void register(IFunction function) {
        functions.put(function.getName(), function);
    }

    public static void registerAll(IFunction ... functions) {
        for (IFunction function : functions) {
            FunctionsHandler.register(function);
        }
    }

    public static String[] getFunctionsNames() {
        return functions.keySet().toArray(new String[0]);
    }

    public MethodResult run(String functionName, IArguments args) throws LuaException {
        Optional<IFunction> function = Optional.ofNullable(functions.get(functionName));
        if (function.isPresent()) {
            for (UUID playerID : this.tardis.getEmotionHandler().getLoyaltyTrackingCrew()) {
                ServerPlayerEntity player;
                if (playerID == null || (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(playerID)) == null) continue;
                this.tardis.getEmotionHandler().addLoyalty((PlayerEntity)player, -HandlesConfig.Common.getLoyaltyPenalty(functionName));
            }
            this.tardis.getEmotionHandler().addMood((double)(-HandlesConfig.Common.getMoodPenalty(functionName)));
            return function.get().run(this.tardis, args);
        }
        return MethodResult.of();
    }
}

