/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.cfg.entries;

import java.util.Objects;
import org.zeith.hammerlib.util.cfg.ConfigEntrySerializer;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.IConfigEntry;

public class ConfigEntryLong
implements IConfigEntry {
    final ConfigFile cfg;
    public long min = Long.MIN_VALUE;
    public long max = Long.MAX_VALUE;
    String description;
    String name;
    Long value;
    Long initialValue;

    public ConfigEntryLong(ConfigFile cfg, Long initialValue) {
        this.value = initialValue;
        this.initialValue = initialValue;
        this.cfg = cfg;
    }

    public ConfigEntryLong setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryLong setMinValue(long min) {
        this.min = min;
        if (this.value != null) {
            this.value = Math.max(min, Math.min(this.max, this.value));
        }
        return this;
    }

    public ConfigEntryLong setMaxValue(long max) {
        this.max = max;
        if (this.value != null) {
            this.value = Math.max(this.min, Math.min(max, this.value));
        }
        return this;
    }

    public ConfigEntryLong setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    public ConfigEntryLong setValue(Long value) {
        if (value != null) {
            value = Math.max(this.min, Math.min(this.max, value));
        }
        if (!Objects.equals(value, this.value)) {
            this.value = value;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Long getValue() {
        if (this.value == null) {
            this.setValue(this.initialValue);
        }
        return this.value;
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return ConfigFile.SERIALIZER_LONG;
    }
}

