/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.tiles.tooltip.own.IRenderableInfo;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltip;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProviderHC;

public class GuiTooltip
implements ITooltip {
    public final LinkedList<TooltipLine> infos = new LinkedList();
    protected World world;
    protected BlockPos pos;
    protected Entity ent;
    protected int width;
    protected int height;

    protected void refresh() {
        this.width = 0;
        this.height = 0;
        for (int i = 0; i < this.infos.size(); ++i) {
            TooltipLine ln = this.infos.get(i);
            ln.refresh();
            this.width = Math.max(this.width, ln.width);
            this.height += ln.height;
        }
    }

    @Override
    public void append(IRenderableInfo info) {
        if (this.infos.isEmpty()) {
            this.newLine();
        }
        this.infos.getLast().addLast(info);
        this.refresh();
    }

    @Override
    public void newLine() {
        this.infos.addLast(new TooltipLine());
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack matrix, float x, float y, float partialTime) {
        for (int i = 0; i < this.infos.size(); ++i) {
            TooltipLine ln = this.infos.get(i);
            ln.render(matrix, x, y, partialTime);
            y += (float)ln.height;
        }
    }

    @Override
    public void reset() {
        this.infos.clear();
        this.refresh();
    }

    @Override
    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public Entity getEntity() {
        return this.ent;
    }

    public GuiTooltip withLocation(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        return this;
    }

    public GuiTooltip withEntity(Entity ent) {
        this.ent = ent;
        this.world = ent.field_70170_p;
        return this;
    }

    public GuiTooltip withProvider(ITooltipProviderHC provider) {
        provider.addInformation(this);
        return this;
    }

    public static class TooltipLine
    extends LinkedList<IRenderableInfo> {
        protected int width;
        protected int height;

        @OnlyIn(value=Dist.CLIENT)
        public void render(MatrixStack matrix, float x, float y, float partialTime) {
            for (int i = 0; i < this.size(); ++i) {
                IRenderableInfo info = (IRenderableInfo)this.get(i);
                info.render(matrix, x, y + (float)((this.height - info.getHeight()) / 2), partialTime);
                x += (float)info.getWidth();
            }
        }

        protected void refresh() {
            this.width = 0;
            this.height = 0;
            for (int i = 0; i < this.size(); ++i) {
                IRenderableInfo info = (IRenderableInfo)this.get(i);
                this.width += info.getWidth();
                this.height = Math.max(this.height, info.getHeight());
            }
        }
    }
}

