/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.zeith.hammerlib.net.IPacket;

public class PacketFactory {
    private static final BiMap<String, Class<IPacket>> PACKET_TYPES = HashBiMap.create();
    private static final BiMap<Class<IPacket>, String> PACKET_TYPES_I = PACKET_TYPES.inverse();
    private static final Map<Class<IPacket>, Supplier<? extends IPacket>> FACTORIES = new HashMap<Class<IPacket>, Supplier<? extends IPacket>>();

    public static byte[] readArray(PacketBuffer buf) {
        short size = buf.readShort();
        return buf.func_189425_b((int)size);
    }

    public static void writeArray(PacketBuffer buf, byte[] data) {
        buf.writeShort(data.length).writeBytes(data);
    }

    public static String getPacketId(IPacket packet) {
        if (packet == null) {
            return "";
        }
        Class<?> type = packet.getClass();
        return (String)PACKET_TYPES_I.getOrDefault(type, (Object)type.getName());
    }

    public static Class<? extends IPacket> getPacketById(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        if (PACKET_TYPES.containsKey((Object)id)) {
            return (Class)PACKET_TYPES.get((Object)id);
        }
        try {
            return Class.forName(id).asSubclass(IPacket.class);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static IPacket createEmpty(String id) {
        Class<? extends IPacket> pkt = PacketFactory.getPacketById(id);
        if (pkt == null) {
            return null;
        }
        if (FACTORIES.containsKey(pkt)) {
            return FACTORIES.get(pkt).get();
        }
        try {
            return (IPacket)IPacket.class.cast(UnsafeHacks.newInstance(pkt));
        }
        catch (Throwable e) {
            return null;
        }
    }
}

