/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net;

import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.java.Threading;

public interface IPacket {
    default public void write(PacketBuffer buf) {
    }

    default public void read(PacketBuffer buf) {
    }

    default public void execute(PacketContext ctx) {
        switch (ctx.getSide()) {
            case CLIENT: {
                this.clientExecute(ctx);
                return;
            }
        }
        this.serverExecute(ctx);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void clientExecute(PacketContext ctx) {
    }

    default public void serverExecute(PacketContext ctx) {
    }

    default public boolean executeOnMainThread() {
        return Threading.isMainThreaded(this.getClass());
    }
}

