/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.listeners;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.zeith.hammerlib.api.LanguageHelper;
import org.zeith.hammerlib.api.tiles.ISyncableTile;
import org.zeith.hammerlib.net.HLTargetPoint;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.SyncTileEntityPacket;
import org.zeith.hammerlib.net.properties.IPropertyTile;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerListener {
    public static final List<TileEntity> NEED_SYNC = new ArrayList<TileEntity>();
    public static final List<TileEntity> NEED_PROP_SYNC = new ArrayList<TileEntity>();

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START && FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            LanguageHelper.update();
        }
        if (e.phase == TickEvent.Phase.END) {
            TileEntity tile;
            while (!NEED_SYNC.isEmpty()) {
                tile = NEED_SYNC.remove(0);
                if (tile instanceof ISyncableTile) {
                    ((ISyncableTile)tile).syncNow();
                    continue;
                }
                Network.sendToArea(new HLTargetPoint((Vector3i)tile.func_174877_v(), 256.0, (RegistryKey<World>)tile.func_145831_w().func_234923_W_()), (IPacket)new SyncTileEntityPacket(tile));
            }
            while (!NEED_PROP_SYNC.isEmpty()) {
                tile = NEED_PROP_SYNC.remove(0);
                if (!(tile instanceof IPropertyTile)) continue;
                ((IPropertyTile)tile).syncPropertiesNow();
            }
        }
    }

    public static void syncProperties(TileEntity tileEntity) {
        NEED_PROP_SYNC.add(tileEntity);
    }

    public static void syncTileEntity(TileEntity tileEntity) {
        NEED_SYNC.add(tileEntity);
    }
}

