/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.items;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.zeith.api.wrench.IWrenchItem;
import org.zeith.api.wrench.IWrenchable;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.util.java.Cast;

@SimplyRegister
public class ItemWrench
extends Item
implements IWrenchItem {
    @RegistryName(value="wrench")
    public static final ItemWrench WRENCH = new ItemWrench(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1));

    public ItemWrench(Item.Properties props) {
        super(props.addToolType(WRENCH_TOOL_TYPE, 1));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K && this.canWrench(stack)) {
            BlockPos pos = context.func_195995_a();
            BlockState state = world.func_180495_p(pos);
            Block blk = state.func_177230_c();
            if (Cast.firstInstanceof(IWrenchable.class, world.func_175625_s(pos), blk).map(w -> w.onWrenchUsed(context)).orElse(false).booleanValue()) {
                this.onWrenchUsed(context);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean canWrench(ItemStack stack) {
        return true;
    }

    @Override
    public void onWrenchUsed(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K && world instanceof ServerWorld) {
            Vector3d e = context.func_221532_j();
            world.func_184148_a(null, e.field_72450_a, e.field_72448_b, e.field_72449_c, SoundEvents.field_187907_gg, SoundCategory.PLAYERS, 1.0f, 1.5f);
        }
    }
}

