/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.event.LanguageReloadEvent;
import org.zeith.hammerlib.util.java.CloseableArrayList;

@Mod.EventBusSubscriber
public class LanguageAdapter {
    private static final Set<String> modids = Sets.newConcurrentHashSet();

    public static void registerMod(String modid) {
        modids.add(modid);
    }

    @SubscribeEvent
    public static void reloadLangs(LanguageReloadEvent e) {
        IReloadableResourceManager mgr = HammerLib.PROXY.getResourceManager();
        if (mgr == null) {
            HammerLib.LOG.warn("Failed to reload HammerLib languages due to lack of available ResourceManager");
            return;
        }
        HammerLib.LOG.debug("Reloading HammerLib-enabled language namespaces: " + mgr.func_199001_a());
        for (String modId : modids) {
            LanguageAdapter.findFirstExisting((IResourceManager)mgr, new ResourceLocation(modId, "langs/" + e.getLang().toLowerCase() + ".hl"), new ResourceLocation(modId, "lang/" + e.getLang().toLowerCase() + ".hl"), new ResourceLocation(modId, "langs/" + e.getLang().toLowerCase() + ".lang"), new ResourceLocation(modId, "lang/" + e.getLang().toLowerCase() + ".lang")).ifPresent(langFile -> {
                HammerLib.LOG.debug("Hooking HammerLib language adapter for namespace " + modId + ": " + langFile);
                try (CloseableArrayList resources = new CloseableArrayList(mgr.func_199004_b(langFile));){
                    for (IResource res : resources) {
                        Scanner in = new Scanner(res.func_199027_b(), "UTF-8");
                        while (in.hasNextLine()) {
                            String[] kv;
                            String line = in.nextLine();
                            if (line.startsWith("#") || (kv = line.split("=", 2)).length != 2) continue;
                            e.translate(kv[0], kv[1]);
                        }
                    }
                }
                catch (Throwable ex) {
                    HammerLib.LOG.error("Failed to load language file located at " + langFile, ex);
                }
            });
        }
    }

    private static Optional<ResourceLocation> findFirstExisting(IResourceManager mgr, ResourceLocation ... paths) {
        for (ResourceLocation path : paths) {
            if (!mgr.func_219533_b(path)) continue;
            return Optional.of(path);
        }
        return Optional.empty();
    }
}

