/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render.item;

import java.io.File;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.client.render.item.ItemTextureRenderer;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class Stack2ImageRenderer {
    private static List<Tuple<ItemTextureRenderer, List<Tuple<ItemStack, File>>>> queue = new ArrayList<Tuple<ItemTextureRenderer, List<Tuple<ItemStack, File>>>>();

    public static void queueRenderer(ItemStack stack, int size, File target) {
        Minecraft.func_71410_x().execute(() -> queue.add((Tuple<ItemTextureRenderer, List<Tuple<ItemStack, File>>>)new Tuple((Object)new ItemTextureRenderer(Minecraft.func_71410_x().field_175621_X, size), new ArrayList<Tuple>(Collections.singletonList(new Tuple((Object)stack, (Object)target))))));
    }

    public static void renderAll(int size) {
        NonNullList sub = NonNullList.func_191196_a();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            NonNullList sb = NonNullList.func_191196_a();
            try {
                item.func_150895_a(item.func_77640_w(), sb);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (ItemStack sbs : sb) {
                sub.add((Object)sbs);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy-hh.mm.ss");
        File faild = new File("hammercore", "renderers" + File.separator + "all-" + sdf.format(Date.from(Instant.now())));
        queue.add((Tuple<ItemTextureRenderer, List<Tuple<ItemStack, File>>>)new Tuple((Object)new ItemTextureRenderer(Minecraft.func_71410_x().field_175621_X, size), new ArrayList(sub.stream().map(s -> {
            ResourceLocation rl = s.func_77973_b().getRegistryName();
            return new Tuple(s, (Object)new File(faild, rl.func_110624_b() + File.separator + (rl.func_110623_a() + (s.func_77952_i() == 0 ? "" : "." + s.func_77952_i()) + (s.func_77942_o() ? "_" + s.func_77978_p() : "") + ".png").replaceAll("[^a-zA-Z0-9\\.\\-]", "_")));
        }).collect(Collectors.toList()))));
    }

    public static void renderMod(String modid, int size) {
        NonNullList sub = NonNullList.func_191196_a();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            NonNullList sb = NonNullList.func_191196_a();
            try {
                item.func_150895_a(item.func_77640_w(), sb);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (ItemStack sbs : sb) {
                if (!sbs.func_77973_b().getRegistryName().func_110624_b().equals(modid)) continue;
                sub.add((Object)sbs);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy-hh.mm.ss");
        File faild = new File("hammercore", "renderers" + File.separator + modid + "-" + sdf.format(Date.from(Instant.now())));
        queue.add((Tuple<ItemTextureRenderer, List<Tuple<ItemStack, File>>>)new Tuple((Object)new ItemTextureRenderer(Minecraft.func_71410_x().field_175621_X, size), new ArrayList(sub.stream().map(s -> {
            ResourceLocation rl = s.func_77973_b().getRegistryName();
            return new Tuple(s, (Object)new File(faild, (rl.func_110623_a() + (s.func_77952_i() == 0 ? "" : "." + s.func_77952_i()) + (s.func_77942_o() ? "_" + s.func_77978_p() : "") + ".png").replaceAll("[^a-zA-Z0-9\\.\\-]", "_")));
        }).collect(Collectors.toList()))));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFrameStart(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START && !queue.isEmpty()) {
            Tuple<ItemTextureRenderer, List<Tuple<ItemStack, File>>> data = queue.get(0);
            if (!((List)data.func_76340_b()).isEmpty()) {
                Tuple remove = (Tuple)((List)data.func_76340_b()).remove(0);
                ItemTextureRenderer a = (ItemTextureRenderer)data.func_76341_a();
                try {
                    a.renderItemstack((ItemStack)remove.func_76341_a(), (File)remove.func_76340_b(), true);
                }
                catch (Throwable er) {
                    er.printStackTrace();
                }
                if (((List)data.func_76340_b()).isEmpty()) {
                    a.close();
                }
            } else {
                queue.remove(0);
            }
        }
    }
}

