/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.inv;

import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SimpleInventory
implements IItemHandlerModifiable,
Iterable<ItemStack>,
INBTSerializable<ListNBT>,
IInventory {
    public final NonNullList<ItemStack> items;
    public int stackSizeLimit = 64;
    public ToIntFunction<Integer> getSlotLimit = s -> this.stackSizeLimit;
    public BiPredicate<Integer, ItemStack> isStackValid = (i, s) -> true;

    public SimpleInventory(int slots) {
        this.items = NonNullList.func_191197_a((int)slots, (Object)ItemStack.field_190927_a);
    }

    public int getSlots() {
        return this.items.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.setStackInSlot(slot, copy);
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.setStackInSlot(slot, copy);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.setStackInSlot(slot, stack.func_77979_a(m));
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack decrStackSize = this.decrStackSize(slot, m);
        return decrStackSize;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        return stack.func_77979_a(amount);
    }

    public int getSlotLimit(int slot) {
        return this.getSlotLimit.applyAsInt(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isStackValid.test(slot, stack);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.isItemValid(slot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
        }
    }

    public void writeToNBT(CompoundNBT nbt, String label) {
        nbt.func_218657_a(label, (INBT)this.writeToNBT(new ListNBT()));
    }

    public void readFromNBT(CompoundNBT nbt, String label) {
        this.readFromNBT(nbt.func_150295_c(label, 10));
    }

    public ListNBT writeToNBT(ListNBT nbt) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.func_190926_b()) continue;
            CompoundNBT tag = stack.serializeNBT();
            tag.func_74768_a("Slot", i);
            nbt.add((Object)tag);
        }
        return nbt;
    }

    public void readFromNBT(ListNBT nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundNBT tag = nbt.func_150305_b(i);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag);
            short slot = tag.func_74765_d("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set((int)slot, (Object)stack);
        }
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.items.iterator();
    }

    public Stream<ItemStack> stream() {
        return this.items.stream();
    }

    public ListNBT serializeNBT() {
        return this.writeToNBT(new ListNBT());
    }

    public void deserializeNBT(ListNBT nbt) {
        this.readFromNBT(nbt);
    }

    public int func_70302_i_() {
        return this.getSlots();
    }

    public boolean func_191420_l() {
        for (ItemStack e : this) {
            if (e.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return this.getStackInSlot(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack stack = (ItemStack)this.items.get(slot);
        if (!stack.func_190926_b()) {
            return stack.func_77979_a(count);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.items.set(slot, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.items.set(slot, (Object)item);
        if (!item.func_190926_b() && item.func_190916_E() > this.func_70297_j_()) {
            item.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.items.set(i, (Object)ItemStack.field_190927_a);
        }
    }
}

