/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.cfg.entries;

import java.io.BufferedWriter;
import java.io.IOException;
import org.zeith.hammerlib.util.cfg.ConfigEntrySerializer;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.ReaderHelper;
import org.zeith.hammerlib.util.cfg.entries.ConfigEntryDouble;

public class ConfigSerializerDouble
extends ConfigEntrySerializer<ConfigEntryDouble> {
    public ConfigSerializerDouble() {
        super("D");
    }

    @Override
    public void write(ConfigFile config, BufferedWriter writer, ConfigEntryDouble entry, int indents) throws IOException {
        if (entry.getDescription() != null) {
            this.writeComment(writer, entry.getDescription() + " (Default: " + entry.initialValue + ", Range: [" + entry.min + ";" + entry.max + "])", indents);
        }
        this.writeIndents(writer, indents);
        writer.write("+" + this.type + ":" + entry.getSerializedName() + "=" + entry.getValue() + "\n\n");
    }

    @Override
    public ConfigEntryDouble read(ConfigFile config, ReaderHelper reader, int indents) throws IOException {
        ConfigEntryDouble lnt = new ConfigEntryDouble(config, null);
        reader.until('+', true);
        if (reader.eat(this.type, true) && reader.eat(':', true)) {
            String name = reader.until('=', true);
            String value = reader.getRest();
            if (value.contains("\n")) {
                value = value.substring(0, value.indexOf(10));
            }
            lnt.name = name;
            try {
                lnt.value = Math.max(lnt.min, Math.min(lnt.max, Double.parseDouble(value)));
            }
            catch (NumberFormatException nfe) {
                lnt.value = null;
            }
        }
        return lnt;
    }
}

