/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.cfg.entries;

import java.math.BigDecimal;
import java.util.Objects;
import org.zeith.hammerlib.util.cfg.ConfigEntrySerializer;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.IConfigEntry;

public class ConfigEntryBigDecimal
implements IConfigEntry {
    final ConfigFile cfg;
    public BigDecimal min;
    public BigDecimal max;
    String description;
    String name;
    BigDecimal value;
    BigDecimal initialValue;

    public ConfigEntryBigDecimal(ConfigFile cfg, BigDecimal initialValue) {
        this.value = initialValue;
        this.initialValue = initialValue;
        this.cfg = cfg;
    }

    public ConfigEntryBigDecimal setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryBigDecimal setMinValue(BigDecimal min) {
        this.min = min;
        if (this.value != null) {
            if (min != null) {
                this.value = this.value.max(min);
            }
            if (this.max != null) {
                this.value = this.value.min(this.max);
            }
        }
        return this;
    }

    public ConfigEntryBigDecimal setMaxValue(BigDecimal max) {
        this.max = max;
        if (this.value != null) {
            if (this.min != null) {
                this.value = this.value.max(this.min);
            }
            if (max != null) {
                this.value = this.value.min(max);
            }
        }
        return this;
    }

    public ConfigEntryBigDecimal setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    public ConfigEntryBigDecimal setValue(BigDecimal value) {
        if (value != null) {
            if (this.min != null) {
                value = value.max(this.min);
            }
            if (this.max != null) {
                value = value.min(this.max);
            }
        }
        if (!Objects.equals(value, this.value)) {
            this.value = value;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BigDecimal getValue() {
        if (this.value == null) {
            this.setValue(this.initialValue);
        }
        return this.value;
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return ConfigFile.SERIALIZER_BIG_DECIMAL;
    }
}

