/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyUUID
implements IProperty<UUID> {
    final DirectStorage<UUID> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyUUID(DirectStorage<UUID> value) {
        this.value = value;
    }

    public PropertyUUID() {
        this(DirectStorage.allocate());
    }

    @Override
    public Class<UUID> getType() {
        return UUID.class;
    }

    @Override
    public UUID set(UUID value) {
        UUID pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(PacketBuffer buf) {
        UUID value = this.value.get();
        buf.writeBoolean(value != null);
        if (value != null) {
            buf.func_179252_a(value);
        }
    }

    @Override
    public void read(PacketBuffer buf) {
        this.value.set(buf.readBoolean() ? buf.func_179253_g() : null);
    }

    @Override
    public UUID get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

