/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.zeith.hammerlib.net.packets.SendPropertiesPacket;
import org.zeith.hammerlib.net.properties.IProperty;

public class PropertyDispatcher {
    public final BiMap<String, IProperty<?>> properties = HashBiMap.create();
    public final BiMap<IProperty<?>, String> propertiesInverse = this.properties.inverse();
    public final Map<String, IProperty<?>> dirty = new HashMap();
    public final Runnable onDirty;

    public PropertyDispatcher(Runnable onDirty) {
        this.onDirty = onDirty;
    }

    public <T> IProperty<T> registerProperty(String id, IProperty<T> property) {
        if (id.startsWith("!")) {
            id = "." + id.substring(1);
        }
        this.properties.put((Object)id, property);
        property.setDispatcher(this);
        return property;
    }

    public IProperty<?> getProperty(String id) {
        if (id.startsWith("!")) {
            id = "." + id.substring(1);
        }
        return (IProperty)this.properties.get((Object)id);
    }

    public void decodeChanges(PacketBuffer buf) {
        String str;
        while ("!".compareTo(str = buf.func_218666_n()) != 0) {
            IProperty prop = (IProperty)this.properties.get((Object)str);
            if (prop == null) continue;
            prop.read(buf);
        }
    }

    public void notifyOfChange(IProperty<?> prop) {
        String id = (String)this.propertiesInverse.get(prop);
        if (prop.hasChanged()) {
            this.dirty.put(id, prop);
            if (this.onDirty != null) {
                this.onDirty.run();
            }
        }
    }

    @Nullable
    public SendPropertiesPacket detectAndGenerateChanges(BlockPos pos, boolean cleanse) {
        ByteBuf bb = Unpooled.buffer();
        PacketBuffer buf = new PacketBuffer(bb);
        if (!this.dirty.isEmpty()) {
            this.dirty.forEach((id, prop) -> {
                if (prop.hasChanged()) {
                    buf.func_180714_a(id);
                    prop.write(buf);
                    if (cleanse) {
                        prop.markChanged(false);
                    }
                }
            });
            if (cleanse) {
                this.dirty.clear();
            }
        }
        buf.func_180714_a("!");
        int size = bb.writerIndex();
        if (size > 0) {
            bb.readerIndex(0);
            byte[] data = new byte[size];
            bb.readBytes(data);
            return new SendPropertiesPacket(pos.func_218275_a(), data);
        }
        return null;
    }
}

