/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.lft;

import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.thread.SidedThreadGroup;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.net.HLTargetPoint;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.lft.ITransportAcceptor;
import org.zeith.hammerlib.net.lft.NetTransport;
import org.zeith.hammerlib.net.lft.PacketTransportInfo;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

public class TransportSession {
    final Class<? extends ITransportAcceptor> acceptor;
    final List<byte[]> pending;
    final ITransportAcceptor acceptori;
    final PipedOutputStream pos;
    final PipedInputStream pis;
    public final String id;
    final int length;
    final LogicalSide createSide;
    private Thread readThread;

    public TransportSession(String id, Class<? extends ITransportAcceptor> acceptor, List<byte[]> data, ITransportAcceptor ai, int length) {
        this.id = id;
        this.acceptor = acceptor;
        this.pending = data;
        this.acceptori = ai;
        this.length = length;
        this.createSide = LogicalSidePredictor.getCurrentLogicalSide();
        PipedInputStream pis = null;
        PipedOutputStream pos = null;
        if (ai != null) {
            pis = new PipedInputStream(length);
            try {
                pos = new PipedOutputStream(pis);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.pis = pis;
        this.pos = pos;
        if (ai != null) {
            SidedThreadGroup stg = this.createSide == LogicalSide.SERVER ? SidedThreadGroups.SERVER : SidedThreadGroups.CLIENT;
            this.readThread = stg.newThread(() -> ai.read(this.pis, length));
            this.readThread.start();
            NetTransport.indexSession(this);
        }
    }

    PacketTransportInfo genPacket() {
        NetTransport.indexSession(this);
        return new PacketTransportInfo(this.id, this.acceptor.getName(), this.length);
    }

    public PacketTransportInfo createPacket() {
        return TransportSession.genCopy(this).genPacket();
    }

    public void sendTo(ServerPlayerEntity player) {
        Network.sendTo((IPacket)this.createPacket(), player);
    }

    public void sendToServer() {
        Network.sendToServer(this.createPacket());
    }

    public void sendToAll() {
        this.sendToPlayersIf((Predicate<ServerPlayerEntity>)Predicates.alwaysTrue());
    }

    public void sendToDimension(RegistryKey<World> dim) {
        this.sendToPlayersIf(mp -> mp.field_70170_p.func_234923_W_().compareTo(dim) == 0);
    }

    public void sendToNearby(HLTargetPoint tp) {
        this.sendToPlayersIf(mp -> mp.field_70170_p.func_234923_W_().compareTo(tp.dim) == 0 && Math.sqrt(mp.func_213303_ch().func_72438_d((Vector3d)tp)) <= tp.range);
    }

    public void sendToPlayersIf(Predicate<ServerPlayerEntity> predicate) {
        MinecraftServer mcs = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (mcs != null) {
            for (ServerPlayerEntity mp : mcs.func_184103_al().func_181057_v()) {
                if (!predicate.test(mp)) continue;
                this.sendTo(mp);
            }
        }
    }

    public void sendToMultiplePlayers(ServerPlayerEntity ... players) {
        for (int i = 0; i < players.length; ++i) {
            this.sendTo(players[i]);
        }
    }

    void accept(byte[] data) {
        if (this.pos != null) {
            try {
                this.pos.write(data);
                this.pos.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void end(PacketContext ctx) {
        Map<String, TransportSession> m;
        ITransportAcceptor acp = this.acceptori;
        if (this.readThread != null) {
            try {
                this.readThread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.readThread.interrupt();
                HammerLib.LOG.error("------- Transport acceptor " + this.acceptor + " failed to read passed data in time it was given, aborting the transmit completion.");
                acp = null;
            }
            this.readThread = null;
        }
        if (acp != null) {
            acp.onTransmissionComplete(ctx);
        }
        if ((m = NetTransport.SESSIONS.get(this.createSide)) != null) {
            m.remove(this.id);
        }
    }

    public static TransportSession genCopy(TransportSession session) {
        ArrayList<byte[]> matrix = new ArrayList<byte[]>(session.pending);
        for (int i = 0; i < matrix.size(); ++i) {
            matrix.set(i, (byte[])((byte[])matrix.get(i)).clone());
        }
        return new TransportSession(UUID.randomUUID().toString(), session.acceptor, matrix, null, session.length);
    }
}

