/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter.recipe;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.RecipeShape;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;

public class ShapedRecipeBuilder
extends RecipeBuilder<ShapedRecipeBuilder> {
    private final Map<Character, Ingredient> dictionary = new HashMap<Character, Ingredient>();
    private RecipeShape shape;

    public ShapedRecipeBuilder(RegisterRecipesEvent event) {
        super(event);
    }

    public ShapedRecipeBuilder shape(int width, int height, String ... shapeKeys) {
        this.shape = new RecipeShape(width, height, shapeKeys);
        return this;
    }

    public ShapedRecipeBuilder shape(String ... shapeKeys) {
        this.shape = new RecipeShape(shapeKeys);
        return this;
    }

    public ShapedRecipeBuilder map(char c, Object ingredient) {
        this.dictionary.put(Character.valueOf(c), RecipeHelper.fromComponent(ingredient));
        return this;
    }

    @Override
    public void register() {
        this.validate();
        if (this.shape == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined shape!");
        }
        if (this.dictionary.isEmpty()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have any defined ingredients!");
        }
        StringBuilder s = new StringBuilder();
        for (String s2 : this.shape.shape) {
            s.append(s2);
        }
        NonNullList aitemstack = NonNullList.func_191197_a((int)(this.shape.width * this.shape.height), (Object)Ingredient.field_193370_a);
        for (int l = 0; l < this.shape.width * this.shape.height; ++l) {
            char c0 = s.charAt(l);
            if (!this.dictionary.containsKey(Character.valueOf(c0))) continue;
            aitemstack.set(l, (Object)this.dictionary.get(Character.valueOf(c0)));
        }
        this.event.add((IRecipe<?>)new ShapedRecipe(this.getIdentifier(), this.group, this.shape.width, this.shape.height, aitemstack, this.result));
    }
}

