/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.Configuration;
import bl4ckscor3.mod.globalxp.compat.ITOPInfoProvider;
import bl4ckscor3.mod.globalxp.xpblock.XPBlockTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import openmods.utils.EnchantmentUtils;

public class XPBlock
extends Block
implements ITOPInfoProvider {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)1.0E-4, (double)1.0E-4, (double)1.0E-4, (double)15.999, (double)15.999, (double)15.999);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public XPBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(12.5f, 2000.0f).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof XPBlockTileEntity) {
            if (!world.field_72995_K) {
                XPBlockTileEntity te = (XPBlockTileEntity)tile;
                if (player.func_225608_bj_()) {
                    int xpToStore = 0;
                    if ((Integer)Configuration.SERVER.storingAmount.get() != -1) {
                        xpToStore = Math.min((Integer)Configuration.SERVER.storingAmount.get(), EnchantmentUtils.getPlayerXP(player));
                    } else if (((Boolean)Configuration.SERVER.storeUntilPreviousLevel.get()).booleanValue()) {
                        int xpForCurrentLevel = EnchantmentUtils.getExperienceForLevel(player.field_71068_ca);
                        xpToStore = EnchantmentUtils.getPlayerXP(player) - xpForCurrentLevel;
                        if (xpToStore == 0 && player.field_71068_ca > 0) {
                            xpToStore = xpForCurrentLevel - EnchantmentUtils.getExperienceForLevel(player.field_71068_ca - 1);
                        }
                    } else {
                        xpToStore = EnchantmentUtils.getPlayerXP(player);
                    }
                    if (xpToStore == 0) {
                        return ActionResultType.PASS;
                    }
                    te.addXP(xpToStore);
                    EnchantmentUtils.addPlayerXP(player, -xpToStore);
                    return ActionResultType.SUCCESS;
                }
                if (!player.func_225608_bj_()) {
                    int xpRetrieved;
                    if ((Integer)Configuration.SERVER.retrievalAmount.get() != -1) {
                        xpRetrieved = (int)((double)te.removeXP((Integer)Configuration.SERVER.retrievalAmount.get()) * (Double)Configuration.SERVER.retrievalPercentage.get());
                    } else if (((Boolean)Configuration.SERVER.retriveUntilNextLevel.get()).booleanValue()) {
                        int xpToRetrieve = EnchantmentUtils.getExperienceForLevel(player.field_71068_ca + 1) - EnchantmentUtils.getPlayerXP(player);
                        xpRetrieved = (int)((double)te.removeXP(xpToRetrieve) * (Double)Configuration.SERVER.retrievalPercentage.get());
                    } else {
                        xpRetrieved = (int)((double)te.getStoredXP() * (Double)Configuration.SERVER.retrievalPercentage.get());
                        te.setStoredXP(0);
                    }
                    if (xpRetrieved > 0) {
                        this.addOrSpawnXPForPlayer(player, xpRetrieved);
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void addOrSpawnXPForPlayer(PlayerEntity player, int amount) {
        if (((Boolean)Configuration.SERVER.retrieveXPOrbs.get()).booleanValue()) {
            if (!player.field_70170_p.field_72995_K) {
                ExperienceOrbEntity orb = new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), amount);
                orb.getPersistentData().func_74757_a("GlobalXPMarker", true);
                player.field_70170_p.func_217376_c((Entity)orb);
            }
        } else {
            int previousLevel = player.field_71068_ca;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.XpChange(player, amount));
            EnchantmentUtils.addPlayerXP(player, amount);
            if (previousLevel != player.field_71068_ca) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.LevelChange(player, player.field_71068_ca));
            }
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof XPBlockTileEntity) {
            return Math.min(15, Math.floorDiv(((XPBlockTileEntity)te).getStoredXP(), (int)((Integer)Configuration.SERVER.xpForComparator.get())));
        }
        return 0;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (world.field_72995_K || !stack.func_77942_o()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof XPBlockTileEntity) {
            CompoundNBT tag = stack.func_77978_p().func_74775_l("BlockEntityTag");
            tag.func_74768_a("x", pos.func_177958_n());
            tag.func_74768_a("y", pos.func_177956_o());
            tag.func_74768_a("z", pos.func_177952_p());
            ((XPBlockTileEntity)te).func_230337_a_(state, tag);
            ((XPBlockTileEntity)te).func_70296_d();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (world.func_175625_s(pos) instanceof XPBlockTileEntity) {
            ((XPBlockTileEntity)te).setDestroyedByCreativePlayer(player.func_184812_l_());
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof XPBlockTileEntity) {
            ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j());
            if (((XPBlockTileEntity)te).getStoredLevels() != 0.0f) {
                CompoundNBT stackTag = new CompoundNBT();
                stackTag.func_218657_a("BlockEntityTag", (INBT)((XPBlockTileEntity)te).func_189515_b(new CompoundNBT()));
                stack.func_77982_d(stackTag);
                XPBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            } else if (!((XPBlockTileEntity)te).isDestroyedByCreativePlayer()) {
                XPBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(world.func_175640_z(pos))));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new XPBlockTileEntity();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof XPBlockTileEntity) {
            probeInfo.horizontal().text((ITextComponent)new TranslationTextComponent("info.globalxp.levels", new Object[]{String.format("%.2f", Float.valueOf(((XPBlockTileEntity)te).getStoredLevels()))}));
            if (mode == ProbeMode.EXTENDED) {
                probeInfo.horizontal().text((ITextComponent)new TranslationTextComponent("info.globalxp.xp", new Object[]{((XPBlockTileEntity)te).getStoredXP()}));
            }
        }
    }
}

