/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.property.BooleanProperty;
import dev.ftb.mods.ftbteams.property.ColorProperty;
import dev.ftb.mods.ftbteams.property.StringProperty;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public abstract class TeamBase {
    public static final StringProperty DISPLAY_NAME = new StringProperty(new ResourceLocation("ftbteams", "display_name"), "", Pattern.compile(".{3,}"));
    public static final StringProperty DESCRIPTION = new StringProperty(new ResourceLocation("ftbteams", "description"), "");
    public static final ColorProperty COLOR = new ColorProperty(new ResourceLocation("ftbteams", "color"), Color4I.WHITE);
    public static final BooleanProperty FREE_TO_JOIN = new BooleanProperty(new ResourceLocation("ftbteams", "free_to_join"), false);
    UUID id = Util.field_240973_b_;
    public final TeamProperties properties;
    final Map<UUID, TeamRank> ranks = new HashMap<UUID, TeamRank>();
    CompoundNBT extraData;
    public final List<TeamMessage> messageHistory;

    public TeamBase() {
        this.properties = new TeamProperties();
        this.extraData = new CompoundNBT();
        this.messageHistory = new ArrayList<TeamMessage>();
    }

    public abstract TeamType getType();

    public abstract boolean isValid();

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Team) {
            return this.id.equals(((Team)o).getId());
        }
        return false;
    }

    public String toString() {
        return this.getStringID();
    }

    public UUID getId() {
        return this.id;
    }

    public CompoundNBT getExtraData() {
        return this.extraData;
    }

    public <T> T getProperty(TeamProperty<T> property) {
        return this.properties.get(property);
    }

    public <T> void setProperty(TeamProperty<T> property, T value) {
        this.properties.set(property, value);
        this.save();
    }

    public String getDisplayName() {
        return this.getProperty(DISPLAY_NAME);
    }

    public String getDescription() {
        return this.getProperty(DESCRIPTION);
    }

    public int getColor() {
        return this.getProperty(COLOR).rgb();
    }

    public boolean isFreeToJoin() {
        return this.getProperty(FREE_TO_JOIN);
    }

    public String getStringID() {
        String s = this.getDisplayName().replaceAll("\\W", "");
        return (s.length() > 50 ? s.substring(0, 50) : s) + "#" + this.getId().toString().substring(0, 8);
    }

    public ITextComponent getName() {
        StringTextComponent text = new StringTextComponent(this.getDisplayName());
        if (this.getType().isPlayer()) {
            text.func_240699_a_(TextFormatting.GRAY);
        } else if (this.getType().isServer()) {
            text.func_240699_a_(TextFormatting.RED);
        } else {
            text.func_240699_a_(TextFormatting.AQUA);
        }
        text.func_230530_a_(text.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbteams info " + this.getStringID())));
        return text;
    }

    public ITextComponent getColoredName() {
        StringTextComponent text = new StringTextComponent(this.getDisplayName());
        text.func_240703_c_(this.getProperty(COLOR).toStyle().func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbteams info " + this.getStringID())));
        return text;
    }

    public void save() {
    }

    public TeamRank getHighestRank(UUID playerId) {
        TeamRank rank = this.ranks.get(playerId);
        if (rank != null) {
            return rank;
        }
        if (this.getProperty(Team.FREE_TO_JOIN).booleanValue()) {
            return TeamRank.INVITED;
        }
        return TeamRank.NONE;
    }

    public boolean isMember(UUID uuid) {
        return this.getHighestRank(uuid).isMember();
    }

    public Map<UUID, TeamRank> getRanked(TeamRank rank) {
        if (rank == TeamRank.NONE) {
            return this.ranks;
        }
        HashMap<UUID, TeamRank> map = new HashMap<UUID, TeamRank>();
        for (Map.Entry<UUID, TeamRank> entry : this.ranks.entrySet()) {
            if (!entry.getValue().is(rank)) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public Set<UUID> getMembers() {
        return this.getRanked(TeamRank.MEMBER).keySet();
    }

    public boolean isAlly(UUID profile) {
        return this.getHighestRank(profile).isAlly();
    }

    public boolean isOfficer(UUID profile) {
        return this.getHighestRank(profile).isOfficer();
    }

    public boolean isInvited(UUID profile) {
        return this.getHighestRank(profile).isInvited();
    }
}

