/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamInfoEvent;
import dev.ftb.mods.ftbteams.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.net.SendMessageResponseMessage;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public abstract class Team
extends TeamBase {
    public final TeamManager manager;
    boolean shouldSave;

    public Team(TeamManager m) {
        this.id = Util.field_240973_b_;
        this.manager = m;
        this.properties.collect();
    }

    @Override
    public boolean isValid() {
        return this.manager.teamMap.containsKey(this.id);
    }

    @Override
    public void save() {
        this.shouldSave = true;
        this.manager.nameMap = null;
    }

    public List<ServerPlayerEntity> getOnlineRanked(TeamRank rank) {
        ArrayList<ServerPlayerEntity> list = new ArrayList<ServerPlayerEntity>();
        for (UUID id : this.getRanked(rank).keySet()) {
            ServerPlayerEntity player = FTBTUtils.getPlayerByUUID(this.manager.server, id);
            if (player == null) continue;
            list.add(player);
        }
        return list;
    }

    public List<ServerPlayerEntity> getOnlineMembers() {
        return this.getOnlineRanked(TeamRank.MEMBER);
    }

    void created(ServerPlayerEntity p) {
        ((Consumer)TeamEvent.CREATED.invoker()).accept(new TeamCreatedEvent(this, p));
        this.save();
        this.manager.save();
    }

    void updateCommands(ServerPlayerEntity player) {
        this.manager.server.func_184103_al().func_187243_f(player);
    }

    void changedTeam(@Nullable Team prev, UUID player, @Nullable ServerPlayerEntity p, boolean deleted) {
        ((Consumer)TeamEvent.PLAYER_CHANGED.invoker()).accept(new PlayerChangedTeamEvent(this, prev, player, p));
        if (prev instanceof PartyTeam) {
            ((Consumer)TeamEvent.PLAYER_LEFT_PARTY.invoker()).accept(new PlayerLeftPartyTeamEvent(prev, (PlayerTeam)this, player, p, deleted));
        } else if (prev instanceof PlayerTeam && p != null) {
            ((Consumer)TeamEvent.PLAYER_JOINED_PARTY.invoker()).accept(new PlayerJoinedPartyTeamEvent(this, (PlayerTeam)prev, p));
        }
        if (deleted && prev != null) {
            ((Consumer)TeamEvent.DELETED.invoker()).accept(new TeamEvent(prev));
        }
        if (p != null) {
            this.updateCommands(p);
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.func_74778_a("id", this.getId().toString());
        tag.func_74778_a("type", this.getType().func_176610_l());
        this.serializeExtraNBT((CompoundNBT)tag);
        SNBTCompoundTag ranksNBT = new SNBTCompoundTag();
        for (Map.Entry entry : this.ranks.entrySet()) {
            ranksNBT.func_74778_a(((UUID)entry.getKey()).toString(), ((TeamRank)((Object)entry.getValue())).func_176610_l());
        }
        tag.func_218657_a("ranks", (INBT)ranksNBT);
        tag.func_218657_a("properties", (INBT)this.properties.write((CompoundNBT)new SNBTCompoundTag()));
        ListNBT messageHistoryTag = new ListNBT();
        for (TeamMessage m : this.messageHistory) {
            SNBTCompoundTag mt = new SNBTCompoundTag();
            mt.singleLine();
            mt.func_74778_a("from", m.sender.toString());
            mt.func_74772_a("date", m.date);
            mt.func_74778_a("text", ITextComponent.Serializer.func_150696_a((ITextComponent)m.text));
            messageHistoryTag.add((Object)mt);
        }
        tag.func_218657_a("message_history", (INBT)messageHistoryTag);
        ((Consumer)TeamEvent.SAVED.invoker()).accept(new TeamEvent(this));
        tag.func_218657_a("extra", (INBT)this.extraData);
        return tag;
    }

    protected void serializeExtraNBT(CompoundNBT tag) {
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.ranks.clear();
        CompoundNBT ranksNBT = tag.func_74775_l("ranks");
        for (String s : ranksNBT.func_150296_c()) {
            this.ranks.put(UUID.fromString(s), (TeamRank)((Object)TeamRank.NAME_MAP.get(ranksNBT.func_74779_i(s))));
        }
        this.properties.read(tag.func_74775_l("properties"));
        this.extraData = tag.func_74775_l("extra");
        this.messageHistory.clear();
        ListNBT messageHistoryTag = tag.func_150295_c("message_history", 10);
        for (int i = 0; i < messageHistoryTag.size(); ++i) {
            CompoundNBT mt = messageHistoryTag.func_150305_b(i);
            this.messageHistory.add(new TeamMessage(UUID.fromString(mt.func_74779_i("from")), mt.func_74763_f("date"), (ITextComponent)ITextComponent.Serializer.func_240643_a_((String)mt.func_74779_i("text"))));
        }
        ((Consumer)TeamEvent.LOADED.invoker()).accept(new TeamEvent(this));
    }

    public int settings(CommandSource source, TeamProperty key, String value) throws CommandSyntaxException {
        if (value.isEmpty()) {
            TranslationTextComponent keyc = new TranslationTextComponent("ftbteamsconfig." + key.id.func_110624_b() + "." + key.id.func_110623_a());
            keyc.func_240699_a_(TextFormatting.YELLOW);
            StringTextComponent valuec = new StringTextComponent(key.toString(this.getProperty(key)));
            valuec.func_240699_a_(TextFormatting.AQUA);
            source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)keyc).func_240702_b_(" is set to ").func_230529_a_((ITextComponent)valuec), true);
        } else {
            Optional optional = key.fromString(value);
            if (!optional.isPresent()) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Failed to parse value!"), true);
                return 0;
            }
            TeamProperties old = this.properties.copy();
            this.setProperty(key, optional.get());
            TranslationTextComponent keyc = new TranslationTextComponent("ftbteamsconfig." + key.id.func_110624_b() + "." + key.id.func_110623_a());
            keyc.func_240699_a_(TextFormatting.YELLOW);
            StringTextComponent valuec = new StringTextComponent(value);
            valuec.func_240699_a_(TextFormatting.AQUA);
            source.func_197030_a((ITextComponent)new StringTextComponent("Set ").func_230529_a_((ITextComponent)keyc).func_240702_b_(" to ").func_230529_a_((ITextComponent)valuec), true);
            ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(this, old));
        }
        return 1;
    }

    @Deprecated
    public int denyInvite(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        if (this.isInvited(player.func_110124_au()) && !this.isMember(player.func_110124_au())) {
            this.ranks.put(player.func_110124_au(), TeamRank.ALLY);
            source.func_197030_a((ITextComponent)new StringTextComponent("Invite denied"), true);
            this.save();
            this.manager.syncAll();
        }
        return 1;
    }

    @Deprecated
    public int info(CommandSource source) throws CommandSyntaxException {
        source.func_197030_a(StringTextComponent.field_240750_d_, false);
        StringTextComponent infoComponent = new StringTextComponent("");
        infoComponent.func_150256_b().func_240713_a_(Boolean.valueOf(true));
        infoComponent.func_240702_b_("== ");
        infoComponent.func_230529_a_(this.getName());
        infoComponent.func_240702_b_(" ==");
        source.func_197030_a((ITextComponent)infoComponent, false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("ftbteams.info.id", new Object[]{new StringTextComponent(this.getId().toString()).func_240699_a_(TextFormatting.YELLOW)}), false);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("ftbteams.info.short_id", new Object[]{new StringTextComponent(this.getStringID()).func_240699_a_(TextFormatting.YELLOW)}).func_240702_b_(" [" + this.getType().func_176610_l() + "]"), false);
        if (this.getOwner().equals(Util.field_240973_b_)) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("ftbteams.info.owner", new Object[]{new TranslationTextComponent("ftbteams.info.owner.none")}), false);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("ftbteams.info.owner", new Object[]{this.manager.getName(this.getOwner())}), false);
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("ftbteams.info.members"), false);
        if (this.getMembers().isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent("ftbteams.info.members.none")), false);
        } else {
            for (UUID member : this.getMembers()) {
                source.func_197030_a((ITextComponent)new StringTextComponent("- ").func_230529_a_(this.manager.getName(member)), false);
            }
        }
        ((Consumer)TeamEvent.INFO.invoker()).accept(new TeamInfoEvent(this, source));
        return 1;
    }

    public UUID getOwner() {
        return Util.field_240973_b_;
    }

    public int msg(ServerPlayerEntity player, String message) throws CommandSyntaxException {
        this.sendMessage(player.func_110124_au(), TextComponentUtils.withLinks((String)message));
        return 1;
    }

    public void sendMessage(UUID from, ITextComponent text) {
        this.messageHistory.add(new TeamMessage(from, System.currentTimeMillis(), text));
        if (this.messageHistory.size() > 1000) {
            this.messageHistory.remove(0);
        }
        StringTextComponent component = new StringTextComponent("<");
        component.func_230529_a_(this.manager.getName(from));
        component.func_240702_b_(" @");
        component.func_230529_a_(this.getName());
        component.func_240702_b_("> ");
        component.func_230529_a_(text);
        for (ServerPlayerEntity p : this.getOnlineMembers()) {
            p.func_146105_b((ITextComponent)component, false);
            new SendMessageResponseMessage(from, text).sendTo(p);
        }
        this.save();
    }
}

