/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl.condition;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.api.RankCondition;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;

public class PlaytimeCondition
implements RankCondition {
    public static final int TICKS = 1;
    public static final int SECONDS = 20;
    public static final int MINUTES = 1200;
    public static final int HOURS = 72000;
    public static final int DAYS = 1728000;
    public static final int WEEKS = 12096000;
    public final int time;
    public final int timeUnit;
    private final Stat<ResourceLocation> stat;

    public PlaytimeCondition(SNBTCompoundTag tag) {
        this.time = tag.func_74762_e("time");
        switch (tag.func_74779_i("time_unit")) {
            case "seconds": {
                this.timeUnit = 20;
                break;
            }
            case "minutes": {
                this.timeUnit = 1200;
                break;
            }
            case "hours": {
                this.timeUnit = 72000;
                break;
            }
            case "days": {
                this.timeUnit = 1728000;
                break;
            }
            case "weeks": {
                this.timeUnit = 12096000;
                break;
            }
            default: {
                this.timeUnit = 1;
            }
        }
        this.stat = Stats.field_199092_j.func_199076_b((Object)Stats.field_188097_g);
    }

    @Override
    public String getType() {
        return "playtime";
    }

    @Override
    public boolean isRankActive(ServerPlayerEntity player) {
        return player.func_147099_x().func_77444_a(this.stat) >= this.time * this.timeUnit;
    }

    @Override
    public void save(SNBTCompoundTag tag) {
        tag.func_74768_a("time", this.time);
        switch (this.timeUnit) {
            case 20: {
                tag.func_74778_a("time_unit", "seconds");
                break;
            }
            case 1200: {
                tag.func_74778_a("time_unit", "minutes");
                break;
            }
            case 72000: {
                tag.func_74778_a("time_unit", "hours");
                break;
            }
            case 1728000: {
                tag.func_74778_a("time_unit", "days");
                break;
            }
            case 12096000: {
                tag.func_74778_a("time_unit", "weeks");
                break;
            }
            default: {
                tag.func_74778_a("time_unit", "ticks");
            }
        }
    }
}

