/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class MultilineTextEditorScreen
extends BaseScreen {
    public final ListConfig<String, StringConfig> config;
    public final ConfigCallback callback;
    public List<TextBox> textBoxes;
    public int active = 0;

    public MultilineTextEditorScreen(ListConfig<String, StringConfig> c, ConfigCallback ca) {
        this.config = c;
        this.callback = ca;
        this.textBoxes = new ArrayList<TextBox>();
        for (String s : (List)c.value) {
            TextBox box = new TextBox((Panel)this);
            box.setText(s);
            this.textBoxes.add(box);
        }
        if (this.textBoxes.isEmpty()) {
            this.textBoxes.add(new TextBox((Panel)this));
        }
        this.textBoxes.get(0).setFocused(true);
    }

    public void addWidgets() {
        this.add((Widget)new TextField((Panel)this).setText((ITextComponent)new StringTextComponent("This is a lame solution but there will be a better one eventually")));
        ((Widget)this.widgets.get(0)).setPos((this.width - ((Widget)this.widgets.get((int)0)).width) / 2, -15);
        this.add(new SimpleButton((Panel)this, (ITextComponent)new TranslationTextComponent("gui.accept"), Icons.ACCEPT, (simpleButton, mouseButton) -> this.saveAndExit()).setPosAndSize(this.width + 6, 6, 16, 16));
        for (int i = 0; i < this.textBoxes.size(); ++i) {
            this.textBoxes.get(i).setPosAndSize(2, 2 + i * 12, this.width - 4, 12);
        }
        this.addAll(this.textBoxes);
    }

    private void saveAndExit() {
        ((List)this.config.value).clear();
        for (TextBox box : this.textBoxes) {
            ((List)this.config.value).add(box.getText());
        }
        this.closeGui();
        this.callback.save(true);
    }

    private void unfocusAll() {
        for (TextBox box : this.textBoxes) {
            box.setFocused(false);
        }
    }

    public boolean keyPressed(Key key) {
        if (key.is(257)) {
            this.unfocusAll();
            ++this.active;
            this.textBoxes.add(this.active, new TextBox((Panel)this));
            this.textBoxes.get(this.active).setFocused(true);
            this.refreshWidgets();
            return true;
        }
        if (key.is(259)) {
            if (this.active > 0 && this.textBoxes.get(this.active).getText().isEmpty()) {
                this.unfocusAll();
                this.textBoxes.remove(this.active);
                --this.active;
                this.textBoxes.get(this.active).setFocused(true);
                this.refreshWidgets();
                return true;
            }
        } else if (key.is(265)) {
            if (this.active > 0) {
                this.unfocusAll();
                --this.active;
                this.textBoxes.get(this.active).setFocused(true);
                return true;
            }
        } else if (key.is(264) && this.active < this.textBoxes.size() - 1) {
            this.unfocusAll();
            ++this.active;
            this.textBoxes.get(this.active).setFocused(true);
            return true;
        }
        return super.keyPressed(key);
    }

    public boolean mousePressed(MouseButton button) {
        this.unfocusAll();
        return super.mousePressed(button);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }
}

