/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests;

import com.mojang.brigadier.CommandDispatcher;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.FTBQuestsBlockEntities;
import dev.ftb.mods.ftbquests.command.FTBQuestsCommands;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.DimensionTask;
import dev.ftb.mods.ftbquests.quest.task.KillTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbteams.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import java.util.List;
import me.shedaniel.architectury.event.events.CommandRegistrationEvent;
import me.shedaniel.architectury.event.events.EntityEvent;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.event.events.TickEvent;
import me.shedaniel.architectury.hooks.PlayerHooks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FTBQuestsEventHandler {
    private List<KillTask> killTasks = null;
    private List<Task> autoSubmitTasks = null;

    public void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverAboutToStart);
        CommandRegistrationEvent.EVENT.register(this::registerCommands);
        LifecycleEvent.SERVER_STARTED.register(this::serverStarted);
        LifecycleEvent.SERVER_STOPPING.register(this::serverStopped);
        LifecycleEvent.SERVER_WORLD_SAVE.register(this::worldSaved);
        FTBQuestsBlocks.register();
        FTBQuestsItems.register();
        FTBQuestsBlockEntities.register();
        ClearFileCacheEvent.EVENT.register(this::fileCacheClear);
        TeamEvent.PLAYER_LOGGED_IN.register(this::playerLoggedIn);
        TeamEvent.CREATED.register(this::teamCreated);
        TeamEvent.PLAYER_CHANGED.register(this::playerChangedTeam);
        EntityEvent.LIVING_DEATH.register(this::playerKill);
        TickEvent.PLAYER_POST.register(this::playerTick);
        PlayerEvent.CRAFT_ITEM.register(this::itemCrafted);
        PlayerEvent.SMELT_ITEM.register(this::itemSmelted);
        PlayerEvent.PLAYER_CLONE.register(this::cloned);
        PlayerEvent.CHANGE_DIMENSION.register(this::changedDimension);
        PlayerEvent.OPEN_MENU.register(this::containerOpened);
    }

    private void serverAboutToStart(MinecraftServer server) {
        ServerQuestFile.INSTANCE = new ServerQuestFile(server);
    }

    private void registerCommands(CommandDispatcher<CommandSource> dispatcher, Commands.EnvironmentType selection) {
        FTBQuestsCommands.register(dispatcher);
    }

    private void serverStarted(MinecraftServer server) {
        ServerQuestFile.INSTANCE.load();
    }

    private void serverStopped(MinecraftServer server) {
        ServerQuestFile.INSTANCE.saveNow();
        ServerQuestFile.INSTANCE.unload();
        ServerQuestFile.INSTANCE = null;
    }

    private void worldSaved(ServerWorld level) {
        if (ServerQuestFile.INSTANCE != null) {
            ServerQuestFile.INSTANCE.saveNow();
        }
    }

    private void fileCacheClear(ClearFileCacheEvent event) {
        if (event.getFile().isServerSide()) {
            this.killTasks = null;
            this.autoSubmitTasks = null;
        }
    }

    private void playerLoggedIn(PlayerLoggedInAfterTeamEvent event) {
        ServerQuestFile.INSTANCE.playerLoggedIn(event);
    }

    private void teamCreated(TeamCreatedEvent event) {
        ServerQuestFile.INSTANCE.teamCreated(event);
    }

    private void playerChangedTeam(PlayerChangedTeamEvent event) {
        ServerQuestFile.INSTANCE.playerChangedTeam(event);
    }

    private ActionResultType playerKill(LivingEntity entity, DamageSource source) {
        if (source.func_76346_g() instanceof ServerPlayerEntity && !PlayerHooks.isFake((PlayerEntity)((PlayerEntity)source.func_76346_g()))) {
            if (this.killTasks == null) {
                this.killTasks = ServerQuestFile.INSTANCE.collect(KillTask.class);
            }
            if (this.killTasks.isEmpty()) {
                return ActionResultType.PASS;
            }
            ServerPlayerEntity player = (ServerPlayerEntity)source.func_76346_g();
            TeamData data = ServerQuestFile.INSTANCE.getData((Entity)player);
            for (KillTask task : this.killTasks) {
                if (data.getProgress(task) >= task.getMaxProgress() || !data.canStartTasks(task.quest)) continue;
                task.kill(data, entity);
            }
        }
        return ActionResultType.PASS;
    }

    private void playerTick(PlayerEntity player) {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (player instanceof ServerPlayerEntity && file != null && !PlayerHooks.isFake((PlayerEntity)player)) {
            if (this.autoSubmitTasks == null) {
                this.autoSubmitTasks = file.collect(o -> o instanceof Task && ((Task)o).autoSubmitOnPlayerTick() > 0);
            }
            if (this.autoSubmitTasks == null || this.autoSubmitTasks.isEmpty()) {
                return;
            }
            TeamData data = file.getData((Entity)player);
            if (data.isLocked()) {
                return;
            }
            long t = player.field_70170_p.func_82737_E();
            file.currentPlayer = (ServerPlayerEntity)player;
            for (Task task : this.autoSubmitTasks) {
                long d = task.autoSubmitOnPlayerTick();
                if (d <= 0L || t % d != 0L || data.isCompleted(task) || !data.canStartTasks(task.quest)) continue;
                task.submitTask(data, (ServerPlayerEntity)player);
            }
            file.currentPlayer = null;
        }
    }

    private void itemCrafted(PlayerEntity player, ItemStack crafted, IInventory inventory) {
        if (player instanceof ServerPlayerEntity && !crafted.func_190926_b()) {
            FTBQuestsInventoryListener.detect((ServerPlayerEntity)player, crafted, 0L);
        }
    }

    private void itemSmelted(PlayerEntity player, ItemStack smelted) {
        if (player instanceof ServerPlayerEntity && !smelted.func_190926_b()) {
            FTBQuestsInventoryListener.detect((ServerPlayerEntity)player, smelted, 0L);
        }
    }

    private void cloned(ServerPlayerEntity oldPlayer, ServerPlayerEntity newPlayer, boolean wonGame) {
        newPlayer.field_71069_bz.func_75132_a((IContainerListener)new FTBQuestsInventoryListener(newPlayer));
        if (wonGame) {
            return;
        }
        if (PlayerHooks.isFake((PlayerEntity)newPlayer) || newPlayer.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            return;
        }
        for (int i = 0; i < oldPlayer.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)oldPlayer.field_71071_by.field_70462_a.get(i);
            if (stack.func_77973_b() != FTBQuestsItems.BOOK.get() || !newPlayer.func_191521_c(stack)) continue;
            oldPlayer.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    private void changedDimension(ServerPlayerEntity player, RegistryKey<World> oldLevel, RegistryKey<World> newLevel) {
        if (!PlayerHooks.isFake((PlayerEntity)player)) {
            ServerQuestFile file = ServerQuestFile.INSTANCE;
            TeamData data = file.getData((Entity)player);
            if (data.isLocked()) {
                return;
            }
            file.currentPlayer = player;
            for (DimensionTask task : file.collect(DimensionTask.class)) {
                task.submitTask(data, player);
            }
            file.currentPlayer = null;
        }
    }

    private void containerOpened(PlayerEntity player, Container menu) {
        if (player instanceof ServerPlayerEntity && !PlayerHooks.isFake((PlayerEntity)player) && !(menu instanceof PlayerContainer)) {
            menu.func_75132_a((IContainerListener)new FTBQuestsInventoryListener((ServerPlayerEntity)player));
        }
    }
}

