/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class VerticalStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType type = (StairsType)((Object)state.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (type == StairsType.VERTICAL && (side == dir || side == dir.func_176735_f())) {
            return SideSkipPredicate.CTM.test(world, pos, state, adjState, side);
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        switch (adjBlock) {
            case FRAMED_VERTICAL_STAIRS: {
                return this.testAgainstVerticalStairs(world, pos, dir, type, adjState, side);
            }
            case FRAMED_STAIRS: {
                return this.testAgainstStairs(world, pos, dir, type, adjState, side);
            }
            case FRAMED_PANEL: {
                return this.testAgainstPanel(world, pos, dir, type, adjState, side);
            }
            case FRAMED_DOUBLE_PANEL: {
                return this.testAgainstDoublePanel(world, pos, dir, type, adjState, side);
            }
            case FRAMED_SLAB_CORNER: {
                return this.testAgainstCorner(world, pos, dir, type, adjState, side);
            }
            case FRAMED_CORNER_PILLAR: {
                return this.testAgainstPillar(world, pos, dir, type, adjState, side);
            }
            case FRAMED_SLAB_EDGE: {
                return this.testAgainstEdge(world, pos, dir, type, adjState, side);
            }
            case FRAMED_HALF_STAIRS: {
                return VerticalStairsSkipPredicate.testAgainstHalfStairs(world, pos, dir, type, adjState, side);
            }
            case FRAMED_VERTICAL_HALF_STAIRS: {
                return VerticalStairsSkipPredicate.testAgainstVerticalHalfStairs(world, pos, dir, type, adjState, side);
            }
            case FRAMED_SLOPE_PANEL: {
                return VerticalStairsSkipPredicate.testAgainstSlopePanel(world, pos, dir, type, adjState, side);
            }
            case FRAMED_EXTENDED_SLOPE_PANEL: {
                return VerticalStairsSkipPredicate.testAgainstExtendedSlopePanel(world, pos, dir, type, adjState, side);
            }
            case FRAMED_DOUBLE_SLOPE_PANEL: {
                return VerticalStairsSkipPredicate.testAgainstDoubleSlopePanel(world, pos, dir, type, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_PANEL: {
                return VerticalStairsSkipPredicate.testAgainstInverseDoubleSlopePanel(world, pos, dir, type, adjState, side);
            }
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (!type.isBottom() && !adjType.isTop() && side == Direction.DOWN || !type.isTop() && !adjType.isBottom() && side == Direction.UP) {
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir.func_176746_e()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        boolean adjBottom;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        boolean bl = adjBottom = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.BOTTOM;
        if (type == StairsType.VERTICAL && (side == Direction.UP && !adjBottom || side == Direction.DOWN && adjBottom)) {
            StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
            if (adjDir == dir && adjShape == StairsShape.INNER_LEFT || adjDir == dir.func_176735_f() && adjShape == StairsShape.INNER_RIGHT) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
        } else if (type.isTop() == adjBottom && (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176734_d() && adjDir == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        if (side == dir.func_176746_e() && (adjDir == dir || adjDir == dir.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        if (side == dir.func_176734_d() && (adjDir == dir.func_176735_f() || adjDir == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side, dir.func_176735_f());
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type == StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if ((side.func_176740_k() == Direction.Axis.Y || side == dir.func_176734_d() || side == dir.func_176746_e()) && type.isTop() != adjTop && dir == adjDir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPillar(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (type == StairsType.VERTICAL ? (side == dir.func_176746_e() || side == dir.func_176734_d()) && adjDir == dir : side.func_176740_k() == Direction.Axis.Y && side == Direction.UP == type.isTop() && adjDir == dir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type == StairsType.VERTICAL || side.func_176740_k() == Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176734_d() && adjDir == dir.func_176735_f()) {
            return adjTop != type.isTop() && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (adjTop == type.isTop()) {
            return false;
        }
        if (adjRight && adjDir == dir && side == dir.func_176735_f() || !adjRight && adjDir == dir.func_176735_f() && side == dir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (!Utils.isY(side) || side == Direction.UP && type == StairsType.TOP_CORNER || side == Direction.DOWN && type == StairsType.BOTTOM_CORNER) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (!Utils.isY(side) || adjDir != dir || adjTop != (side == Direction.DOWN)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstSlopePanel(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL || side != dir.func_176734_d() && side != dir.func_176746_e()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (!adjFront && (adjDir == dir && adjRot == Rotation.RIGHT || adjDir == dir.func_176735_f() && adjRot == Rotation.LEFT)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjFront && (adjDir == dir.func_176734_d() && adjRot == Rotation.LEFT || adjDir == dir.func_176746_e() && adjRot == Rotation.RIGHT)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL || side != dir.func_176734_d() && side != dir.func_176746_e()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (side == dir.func_176734_d() && adjDir == dir.func_176735_f() && adjRot == Rotation.RIGHT) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir.func_176746_e() && adjDir == dir && adjRot == Rotation.LEFT) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL || side != dir.func_176734_d() && side != dir.func_176746_e()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (adjRot.isVertical()) {
            return false;
        }
        if (!(adjFront || adjDir != dir && adjDir != dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjFront && (adjDir == dir.func_176734_d() || adjDir == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (type != StairsType.VERTICAL || side != dir.func_176734_d() && side != dir.func_176746_e()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (adjDir.func_176740_k() == dir.func_176740_k() && adjRot == Rotation.LEFT) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjDir.func_176740_k() == dir.func_176746_e().func_176740_k() && adjRot == Rotation.RIGHT) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

