/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class StairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(world, pos, state, adjState, side)) {
            return true;
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a);
        StairsShape shape = (StairsShape)state.func_177229_b((Property)StairsBlock.field_176310_M);
        boolean top = state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP;
        switch (adjBlock) {
            case FRAMED_STAIRS: {
                return this.testAgainstStairs(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_SLAB: {
                return this.testAgainstSlab(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLAB: {
                return this.testAgainstDoubleSlab(world, pos, dir, shape, top, side);
            }
            case FRAMED_SLAB_EDGE: {
                return this.testAgainstEdge(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_PANEL: {
                return this.testAgainstPanel(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_DOUBLE_PANEL: {
                return this.testAgainstDoublePanel(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_CORNER_PILLAR: {
                return this.testAgainstPillar(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_SLAB_CORNER: {
                return this.testAgainstCorner(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_VERTICAL_STAIRS: {
                return this.testAgainstVerticalStairs(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_HALF_STAIRS: {
                return StairsSkipPredicate.testAgainstHalfStairs(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_SLOPE_SLAB: {
                return StairsSkipPredicate.testAgainstSlopeSlab(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_ELEVATED_SLOPE_SLAB: {
                return StairsSkipPredicate.testAgainstElevatedSlopeSlab(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLOPE_SLAB: {
                return StairsSkipPredicate.testAgainstDoubleSlopeSlab(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_SLAB: {
                return StairsSkipPredicate.testAgainstInverseDoubleSlopeSlab(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_VERTICAL_HALF_STAIRS: {
                return StairsSkipPredicate.testAgainstVerticalHalfStairs(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_SLOPE_PANEL: {
                return StairsSkipPredicate.testAgainstSlopePanel(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_EXTENDED_SLOPE_PANEL: {
                return StairsSkipPredicate.testAgainstExtendedSlopePanel(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLOPE_PANEL: {
                return StairsSkipPredicate.testAgainstDoubleSlopePanel(world, pos, dir, shape, top, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_PANEL: {
                return StairsSkipPredicate.testAgainstInverseDoubleSlopePanel(world, pos, dir, shape, top, adjState, side);
            }
        }
        return false;
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)StairsBlock.field_176309_a);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)StairsBlock.field_176310_M);
        boolean bl = adjTop = adjState.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP;
        if (StairsSkipPredicate.isStairSide(shape, dir, side) && StairsSkipPredicate.isStairSide(adjShape, adjDir, side.func_176734_d()) || StairsSkipPredicate.isSlabSide(shape, dir, side) && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.func_176734_d())) {
            return adjTop == top && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side.func_176740_k() == Direction.Axis.Y && adjDir == dir && adjShape == shape && adjTop != top) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstSlab(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (top != adjTop) {
            return false;
        }
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side);
    }

    private boolean testAgainstDoubleSlab(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (top != adjTop) {
            return false;
        }
        if (adjDir == side.func_176734_d()) {
            if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
                return false;
            }
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (top && side == Direction.DOWN || !top && side == Direction.UP) {
            if (shape != StairsShape.STRAIGHT) {
                return false;
            }
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
    }

    private boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        if (dir == adjDir || dir.func_176734_d() == adjDir) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstPillar(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (shape == StairsShape.OUTER_LEFT && dir == adjDir || shape == StairsShape.OUTER_RIGHT && dir.func_176746_e() == adjDir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (shape == StairsShape.OUTER_LEFT && dir == adjDir || shape == StairsShape.OUTER_RIGHT && dir.func_176746_e() == adjDir) {
            return adjTop == top && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL ? (side == Direction.DOWN && top || side == Direction.UP && !top) && (shape == StairsShape.INNER_LEFT && adjDir == dir || shape == StairsShape.INNER_RIGHT && adjDir == dir.func_176746_e()) : adjType.isTop() != top && (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176735_f() && adjDir == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (!StairsSkipPredicate.isStairSide(shape, dir, side) || top != adjTop) {
            return false;
        }
        Direction adjStairFace = adjRight ? adjDir.func_176746_e() : adjDir.func_176735_f();
        return adjStairFace == side.func_176734_d() && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        return adjDir == side.func_176734_d() && adjTopHalf == top && StairsSkipPredicate.isSlabSide(shape, dir, side) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstElevatedSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        return adjDir == side && adjTop == top && StairsSkipPredicate.isSlabSide(shape, dir, side) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstDoubleSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (adjDir != side && adjDir != side.func_176734_d()) {
            return false;
        }
        return adjTopHalf == top && StairsSkipPredicate.isSlabSide(shape, dir, side) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        return (adjDir == side && !top || adjDir == side.func_176734_d() && top) && StairsSkipPredicate.isSlabSide(shape, dir, side) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstVerticalHalfStairs(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side) || adjTop != top) {
            return false;
        }
        if (adjDir == side.func_176734_d() || adjDir == side.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || !top && side != Direction.UP || top && side != Direction.DOWN) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (!adjRot.isVertical() || adjRot == Rotation.DOWN != top) {
            return false;
        }
        if (adjDir == dir && !adjFront || adjDir == dir.func_176734_d() && adjFront) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || !top && side != Direction.UP || top && side != Direction.DOWN) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (adjDir == dir && (!top && adjRot == Rotation.DOWN || top && adjRot == Rotation.UP)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT || !top && side != Direction.UP || top && side != Direction.DOWN) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (!adjRot.isVertical()) {
            return false;
        }
        if (adjDir == dir && !adjFront || adjDir == dir.func_176734_d() && adjFront) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        boolean sameOrientation;
        if (shape != StairsShape.STRAIGHT || !top && side != Direction.UP || top && side != Direction.DOWN) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (!adjRot.isVertical()) {
            return false;
        }
        boolean bl = sameOrientation = top == (adjRot == Rotation.UP);
        if (adjDir == dir && sameOrientation || adjDir == dir.func_176734_d() && !sameOrientation) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    public static boolean isStairSide(StairsShape shape, Direction dir, Direction side) {
        if (shape == StairsShape.STRAIGHT) {
            return side == dir.func_176746_e() || side == dir.func_176735_f();
        }
        if (shape == StairsShape.INNER_LEFT) {
            return side == dir.func_176734_d() || side == dir.func_176746_e();
        }
        if (shape == StairsShape.INNER_RIGHT) {
            return side == dir.func_176734_d() || side == dir.func_176735_f();
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return side == dir || side == dir.func_176735_f();
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return side == dir || side == dir.func_176746_e();
        }
        return false;
    }

    public static boolean isSlabSide(StairsShape shape, Direction dir, Direction side) {
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT) {
            return false;
        }
        if (shape == StairsShape.STRAIGHT) {
            return side == dir.func_176734_d();
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return side == dir.func_176734_d() || side == dir.func_176746_e();
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return side == dir.func_176734_d() || side == dir.func_176735_f();
        }
        return false;
    }
}

