/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class SlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation rot = (Rotation)((Object)state.func_177229_b(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(dir);
        boolean front = (Boolean)state.func_177229_b((Property)PropertyHolder.FRONT);
        if (side == dir) {
            return !front && SideSkipPredicate.CTM.test(world, pos, state, adjState, side);
        }
        Block block = adjState.func_177230_c();
        if (block instanceof IFramedBlock) {
            switch (((IFramedBlock)block).getBlockType()) {
                case FRAMED_SLOPE_PANEL: {
                    return SlopePanelSkipPredicate.testAgainstSlopePanel(world, pos, dir, rot, rotDir, front, adjState, side);
                }
                case FRAMED_EXTENDED_SLOPE_PANEL: {
                    return SlopePanelSkipPredicate.testAgainstExtendedSlopePanel(world, pos, dir, rot, rotDir, front, adjState, side);
                }
                case FRAMED_DOUBLE_SLOPE_PANEL: {
                    return SlopePanelSkipPredicate.testAgainstDoubleSlopePanel(world, pos, dir, rot, rotDir, front, adjState, side);
                }
                case FRAMED_INV_DOUBLE_SLOPE_PANEL: {
                    return SlopePanelSkipPredicate.testAgainstInverseDoubleSlopePanel(world, pos, dir, rot, rotDir, front, adjState, side);
                }
                case FRAMED_SLAB_EDGE: {
                    return SlopePanelSkipPredicate.testAgainstSlabEdge(world, pos, dir, rot, rotDir, front, adjState, side);
                }
                case FRAMED_PANEL: {
                    return SlopePanelSkipPredicate.testAgainstPanel(world, pos, dir, rotDir, front, adjState, side);
                }
                case FRAMED_DOUBLE_PANEL: {
                    return SlopePanelSkipPredicate.testAgainstDoublePanel(world, pos, dir, rotDir, front, adjState, side);
                }
                case FRAMED_CORNER_PILLAR: {
                    return SlopePanelSkipPredicate.testAgainstCornerPillar(world, pos, dir, rot, rotDir, front, adjState, side);
                }
                case FRAMED_STAIRS: {
                    return SlopePanelSkipPredicate.testAgainstStairs(world, pos, dir, rot, rotDir, front, adjState, side);
                }
                case FRAMED_VERTICAL_STAIRS: {
                    return SlopePanelSkipPredicate.testAgainstVerticalStairs(world, pos, dir, rot, rotDir, front, adjState, side);
                }
                case FRAMED_HALF_STAIRS: {
                    return SlopePanelSkipPredicate.testAgainstHalfStairs(world, pos, dir, rot, rotDir, front, adjState, side);
                }
            }
            return false;
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(IBlockReader world, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (side == rotDir.func_176734_d() && adjRot == rot.getOpposite() && (adjDir == dir && adjFront == front || adjDir == dir.func_176734_d() && adjFront != front)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side.func_176740_k() != dir.func_176740_k() && side.func_176740_k() != rotDir.func_176740_k() && adjDir == dir && adjRot == rot && adjFront == front) {
            return SideSkipPredicate.compareState(world, pos, side, rotDir.func_176734_d(), rotDir);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(IBlockReader world, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (adjRot == rot && (adjDir == dir && !front || adjDir == dir.func_176734_d() && front)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (side == rotDir.func_176734_d() && (adjRot == rot || adjRot == rot.getOpposite()) && (adjDir == dir && adjFront == front || adjDir == dir.func_176734_d() && adjFront != front)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side.func_176740_k() != dir.func_176740_k() && side.func_176740_k() != rotDir.func_176740_k() && (adjDir == dir && adjRot == rot && adjFront == front || adjDir == dir.func_176734_d() && adjRot == rot.getOpposite() && adjFront != front)) {
            return SideSkipPredicate.compareState(world, pos, side, rotDir.func_176734_d(), rotDir.func_176734_d());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.func_176734_d() && (side.func_176740_k() == dir.func_176740_k() || side.func_176740_k() == rotDir.func_176740_k())) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (side == rotDir.func_176734_d() && adjRot == rot && (adjDir == dir && !front || adjDir == dir.func_176734_d() && front)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side != rotDir.func_176734_d() && front && (adjDir == dir && adjRot == rot || adjDir == dir.func_176734_d() && adjRot == rot.getOpposite())) {
            return SideSkipPredicate.compareState(world, pos, side, rotDir.func_176734_d(), rotDir.func_176734_d());
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(IBlockReader world, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (!rot.isVertical() || side != rotDir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop == (rot == Rotation.UP) && (adjDir == dir && !front || adjDir == dir.func_176734_d() && front)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (adjDir == dir && !front || adjDir == dir.func_176734_d() && front) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        return (adjDir == dir || adjDir == dir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side, side, front ? dir.func_176734_d() : dir);
    }

    private static boolean testAgainstCornerPillar(IBlockReader world, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (rot.isVertical() || side != rotDir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (!front && (adjDir == dir || adjDir == dir.func_176746_e()) || front && (adjDir == dir.func_176734_d() || adjDir == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        boolean adjTop;
        if (!rot.isVertical() || side != rotDir.func_176734_d()) {
            return false;
        }
        if (adjState.func_177229_b((Property)StairsBlock.field_176310_M) != StairsShape.STRAIGHT) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)StairsBlock.field_176309_a);
        boolean bl = adjTop = adjState.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP;
        if (!front && adjDir == dir || front && adjDir == dir.func_176734_d()) {
            return adjTop == (rot == Rotation.DOWN) && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (rot.isVertical() || side != rotDir.func_176734_d()) {
            return false;
        }
        if (adjState.func_177229_b(PropertyHolder.STAIRS_TYPE) != StairsType.VERTICAL) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (!front && (adjDir == dir && rot == Rotation.RIGHT || adjDir == dir.func_176746_e() && rot == Rotation.LEFT)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (front && (adjDir == dir.func_176734_d() && rot == Rotation.LEFT || adjDir == dir.func_176735_f() && rot == Rotation.RIGHT)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, Rotation rot, Direction rotDir, boolean front, BlockState adjState, Direction side) {
        if (side != rotDir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (rot.isVertical()) {
            if ((Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP) != (rot == Rotation.UP)) {
                return false;
            }
            if (!adjRight && (adjDir == dir.func_176746_e() && !front || adjDir == dir.func_176735_f() && front)) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
            if (adjRight && (adjDir == dir.func_176735_f() && !front || adjDir == dir.func_176746_e() && front)) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
        } else if (adjDir == side.func_176734_d()) {
            if (!adjRight && (adjDir == dir.func_176746_e() && !front || adjDir == dir.func_176735_f() && front)) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
            if (adjRight && (adjDir == dir.func_176735_f() && !front || adjDir == dir.func_176746_e() && front)) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
        }
        return false;
    }
}

