/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

public class FramedRailSlopeBlock
extends AbstractRailBlock
implements IFramedBlock {
    private final Map<BlockState, VoxelShape> shapes = this.getBlockType().generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());

    public FramedRailSlopeBlock() {
        super(true, IFramedBlock.createProperties(BlockType.FRAMED_RAIL_SLOPE));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PropertyHolder.SOLID, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PropertyHolder.GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.ASCENDING_RAIL_SHAPE, BlockStateProperties.field_208198_y, PropertyHolder.SOLID, PropertyHolder.GLOWING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        RailShape shape = FramedRailSlopeBlock.shapeFromDirection(context.func_195992_f());
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean waterlogged = fluidState.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)shape)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(waterlogged));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.field_72995_K && world.func_180495_p(pos).func_203425_a((Block)this)) {
            this.func_189541_b(state, world, pos, block);
        }
    }

    public static RailShape shapeFromDirection(Direction dir) {
        switch (dir) {
            case NORTH: {
                return RailShape.ASCENDING_NORTH;
            }
            case EAST: {
                return RailShape.ASCENDING_EAST;
            }
            case SOUTH: {
                return RailShape.ASCENDING_SOUTH;
            }
            case WEST: {
                return RailShape.ASCENDING_WEST;
            }
        }
        throw new IllegalArgumentException("Invalid facing " + dir);
    }

    public static Direction directionFromShape(RailShape shape) {
        switch (shape) {
            case ASCENDING_NORTH: {
                return Direction.NORTH;
            }
            case ASCENDING_EAST: {
                return Direction.EAST;
            }
            case ASCENDING_SOUTH: {
                return Direction.SOUTH;
            }
            case ASCENDING_WEST: {
                return Direction.WEST;
            }
        }
        throw new IllegalArgumentException("Invalid shape " + shape);
    }

    public Property<RailShape> func_176560_l() {
        return PropertyHolder.ASCENDING_RAIL_SHAPE;
    }

    public final ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.handleBlockActivated(world, pos, player, hand, hit);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(world, pos, placer, stack);
    }

    public boolean func_220074_n(BlockState state) {
        return (Boolean)state.func_177229_b((Property)PropertyHolder.SOLID);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getCamoOcclusionShape(state, world, pos);
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return this.getCamoVisualShape(state, world, pos, ctx);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getLight(world, pos);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return this.getSound(state, world, pos);
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return this.getCamoBlastResistance(state, world, pos, explosion);
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.isCamoFlammable(world, pos, face);
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getCamoFlammability(world, pos, face);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return this.getDrops(super.func_220076_a(state, builder), builder);
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, world, pos, entity);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.shapes.get(state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (context instanceof EntitySelectionContext && context.getEntity() instanceof AbstractMinecartEntity) {
            return VoxelShapes.func_197880_a();
        }
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return Fluids.field_204541_a.func_207188_f();
    }

    public final boolean hasTileEntity(BlockState state) {
        return true;
    }

    public final TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedTileEntity();
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.FRAMED_RAIL_SLOPE;
    }
}

