/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedTrapDoorModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final boolean open;

    public FramedTrapDoorModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        this.top = state.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        this.open = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208193_t);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad sideQuad;
        if (this.open) {
            if (quad.func_178210_d() == this.dir) {
                BakedQuad frontQuad = ModelUtils.duplicateQuad(quad);
                BakedQuadTransformer.setQuadPosInFacingDir(frontQuad, 0.1875f);
                quadMap.get(null).add(frontQuad);
            } else if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir, 0.1875f)) {
                    quadMap.get(quad.func_178210_d()).add(topBotQuad);
                }
            } else {
                boolean facePositive;
                BakedQuad sideQuad2 = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createVerticalSideQuad(sideQuad2, !(facePositive = this.dir.func_176743_c() == Direction.AxisDirection.POSITIVE), 0.1875f)) {
                    quadMap.get(quad.func_178210_d()).add(sideQuad2);
                }
            }
        } else if (this.top && quad.func_178210_d() == Direction.DOWN || !this.top && quad.func_178210_d() == Direction.UP) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.1875f);
            quadMap.get(null).add(topBotQuad);
        } else if (quad.func_178210_d().func_176740_k() != Direction.Axis.Y && BakedQuadTransformer.createHorizontalSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), this.top, 0.1875f)) {
            quadMap.get(quad.func_178210_d()).add(sideQuad);
        }
    }
}

