/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.tileentity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.server.ServerWorld;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

public class FramedSignTileEntity
extends FramedTileEntity {
    private final ITextComponent[] lines = new ITextComponent[4];
    private final IReorderingProcessor[] renderLines = new IReorderingProcessor[4];
    private DyeColor textColor = DyeColor.BLACK;
    private PlayerEntity editingPlayer;

    public FramedSignTileEntity() {
        super((TileEntityType)FBContent.tileTypeFramedSign.get());
        for (int i = 0; i < 4; ++i) {
            this.lines[i] = new StringTextComponent("");
        }
    }

    public void setLine(int line, ITextComponent text) {
        this.lines[line] = text;
        this.renderLines[line] = null;
    }

    public ITextComponent getLine(int line) {
        return this.lines[line];
    }

    public IReorderingProcessor getRenderedLine(int line, Function<ITextComponent, IReorderingProcessor> converter) {
        if (this.lines[line] != null && this.renderLines[line] == null) {
            this.renderLines[line] = converter.apply(this.lines[line]);
        }
        return this.renderLines[line];
    }

    public boolean executeCommand(ServerPlayerEntity player) {
        for (ITextComponent line : this.lines) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = line == null ? null : line.func_150256_b();
            if (style == null || style.func_150235_h() == null || (clickevent = style.func_150235_h()).func_150669_a() != ClickEvent.Action.RUN_COMMAND) continue;
            player.func_184102_h().func_195571_aL().func_197059_a(this.getCommandSource(player), clickevent.func_150668_b());
        }
        return true;
    }

    private CommandSource getCommandSource(ServerPlayerEntity player) {
        String nameString = player == null ? "Sign" : player.func_200200_C_().getString();
        StringTextComponent name = player == null ? new StringTextComponent("Sign") : player.func_145748_c_();
        Vector3d posVec = new Vector3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        return new CommandSource(ICommandSource.field_213139_a_, posVec, Vector2f.field_189974_a, (ServerWorld)this.field_145850_b, 2, nameString, (ITextComponent)name, this.field_145850_b.func_73046_m(), (Entity)player);
    }

    public boolean setTextColor(DyeColor color) {
        if (this.textColor != color) {
            this.textColor = color;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            return true;
        }
        return false;
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public PlayerEntity getEditingPlayer() {
        return this.editingPlayer;
    }

    public void setEditingPlayer(PlayerEntity player) {
        this.editingPlayer = player;
    }

    public boolean func_183000_F() {
        return true;
    }

    @Override
    protected void writeToDataPacket(CompoundNBT nbt) {
        super.writeToDataPacket(nbt);
        this.writeToNbt(nbt);
    }

    @Override
    protected boolean readFromDataPacket(CompoundNBT nbt) {
        this.readFromNbt(nbt);
        return super.readFromDataPacket(nbt);
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.writeToNbt(nbt);
        return nbt;
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        this.readFromNbt(nbt);
    }

    private void writeToNbt(CompoundNBT nbt) {
        for (int i = 0; i < 4; ++i) {
            nbt.func_74778_a("text" + i, ITextComponent.Serializer.func_150696_a((ITextComponent)this.lines[i]));
        }
        nbt.func_74778_a("color", this.textColor.func_176762_d());
    }

    private void readFromNbt(CompoundNBT nbt) {
        for (int i = 0; i < 4; ++i) {
            String s = nbt.func_74779_i("text" + i);
            IFormattableTextComponent line = ITextComponent.Serializer.func_240643_a_((String)(s.isEmpty() ? "\"\"" : s));
            if (this.field_145850_b instanceof ServerWorld && line != null) {
                try {
                    this.lines[i] = TextComponentUtils.func_240645_a_((CommandSource)this.getCommandSource(null), (ITextComponent)line, null, (int)0);
                }
                catch (CommandSyntaxException e) {
                    this.lines[i] = line;
                }
            } else {
                this.lines[i] = line;
            }
            this.renderLines[i] = null;
        }
        this.textColor = DyeColor.func_204271_a((String)nbt.func_74779_i("color"), (DyeColor)DyeColor.BLACK);
    }

    @Override
    public CompoundNBT writeToBlueprint() {
        return super.func_189515_b(new CompoundNBT());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.writeToNbt(nbt);
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.readFromNbt(nbt);
    }
}

