/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class SlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (side.func_176740_k() == Direction.Axis.Y) {
            return SideSkipPredicate.CTM.test(world, pos, state, adjState, side);
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        switch (adjBlock) {
            case FRAMED_SLAB: {
                return this.testAgainstSlab(world, pos, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLAB: {
                return this.testAgainstDoubleSlab(world, pos, top, side);
            }
            case FRAMED_SLAB_EDGE: {
                return this.testAgainstEdge(world, pos, top, adjState, side);
            }
            case FRAMED_STAIRS: {
                return this.testAgainstStairs(world, pos, top, adjState, side);
            }
            case FRAMED_SLOPE_SLAB: {
                return SlabSkipPredicate.testAgainstSlopeSlab(world, pos, top, adjState, side);
            }
            case FRAMED_ELEVATED_SLOPE_SLAB: {
                return SlabSkipPredicate.testAgainstElevatedSlopeSlab(world, pos, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLOPE_SLAB: {
                return SlabSkipPredicate.testAgainstDoubleSlopeSlab(world, pos, top, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_SLAB: {
                return SlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(world, pos, top, adjState, side);
            }
            case FRAMED_VERTICAL_HALF_STAIRS: {
                return SlabSkipPredicate.testAgainstVerticalHalfStairs(world, pos, top, adjState, side);
            }
        }
        return false;
    }

    private boolean testAgainstSlab(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private boolean testAgainstDoubleSlab(IBlockReader world, BlockPos pos, boolean top, Direction side) {
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(world, pos, side, face);
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP)) {
            return false;
        }
        if (adjState.func_177229_b((Property)PropertyHolder.FACING_HOR) != side.func_176734_d()) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
        boolean bl = adjTop = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        if (top == adjTop && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (Utils.isY(side)) {
            return false;
        }
        return adjDir == side.func_176734_d() && adjTopHalf == top && SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstElevatedSlopeSlab(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (Utils.isY(side)) {
            return false;
        }
        return adjDir == side && adjTop == top && SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstDoubleSlopeSlab(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (Utils.isY(side)) {
            return false;
        }
        return (adjDir == side || adjDir == side.func_176734_d()) && adjTopHalf == top && SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (Utils.isY(side)) {
            return false;
        }
        return (adjDir == side && !top || adjDir == side.func_176734_d() && top) && SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstVerticalHalfStairs(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (Utils.isY(side)) {
            return false;
        }
        if (adjTop == top && (adjDir == side.func_176734_d() || adjDir == side.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        return false;
    }
}

