/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.CtmPredicate;

public class FramedStairsBlock
extends StairsBlock
implements IFramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        if (dir == Direction.UP) {
            return state.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        }
        if (dir == Direction.DOWN) {
            return state.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.BOTTOM;
        }
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape shape = (StairsShape)state.func_177229_b((Property)BlockStateProperties.field_208146_au);
        if (shape == StairsShape.STRAIGHT) {
            return facing == dir;
        }
        if (shape == StairsShape.INNER_LEFT) {
            return facing == dir || facing.func_176735_f() == dir;
        }
        if (shape == StairsShape.INNER_RIGHT) {
            return facing == dir || facing.func_176746_e() == dir;
        }
        return false;
    };

    public FramedStairsBlock() {
        super(() -> ((Block)FBContent.blockFramedCube.get()).func_176223_P(), IFramedBlock.createProperties(BlockType.FRAMED_STAIRS));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.SOLID, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PropertyHolder.GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PropertyHolder.SOLID, PropertyHolder.GLOWING});
    }

    public final ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.handleBlockActivated(world, pos, player, hand, hit);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(world, pos, placer, stack);
    }

    public boolean func_220074_n(BlockState state) {
        return (Boolean)state.func_177229_b((Property)PropertyHolder.SOLID);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getCamoOcclusionShape(state, world, pos);
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return this.getCamoVisualShape(state, world, pos, ctx);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getLight(world, pos);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return this.getSound(state, world, pos);
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return this.getCamoBlastResistance(state, world, pos, explosion);
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.isCamoFlammable(world, pos, face);
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.getCamoFlammability(world, pos, face);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return this.getDrops(super.func_220076_a(state, builder), builder);
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, world, pos, entity);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        if (this.isIntangible(state, world, pos, ctx)) {
            return VoxelShapes.func_197880_a();
        }
        return super.func_220053_a(state, world, pos, ctx);
    }

    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        return IFramedBlock.suppressParticles(state, world, ((BlockRayTraceResult)target).func_216350_a());
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return IFramedBlock.suppressParticles(state, world, pos);
    }

    public final boolean hasTileEntity(BlockState state) {
        return true;
    }

    public final TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedTileEntity();
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.FRAMED_STAIRS;
    }
}

