/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.ModList;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedDiagonalFenceModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedFenceModel
extends FramedBlockModel {
    private final boolean north;
    private final boolean east;
    private final boolean south;
    private final boolean west;

    public FramedFenceModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.north = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D);
        this.east = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E);
        this.south = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F);
        this.west = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.375f, 0.375f, 0.625f, 0.625f)) {
                quadMap.get(quad.func_178210_d()).add(topBotQuad);
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad, quad.func_178210_d().func_176746_e(), 0.625f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, quad.func_178210_d().func_176735_f(), 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
        }
        this.createFenceBars(quadMap, quad, Direction.NORTH, this.north);
        this.createFenceBars(quadMap, quad, Direction.EAST, this.east);
        this.createFenceBars(quadMap, quad, Direction.SOUTH, this.south);
        this.createFenceBars(quadMap, quad, Direction.WEST, this.west);
    }

    private void createFenceBars(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean active) {
        if (active) {
            if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.func_176734_d(), 0.375f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.func_176746_e(), 0.5625f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.func_176735_f(), 0.5625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.func_178210_d() == Direction.UP ? 0.9375f : 0.25f);
                    quadMap.get(null).add(topBotQuad);
                    topBotQuad = ModelUtils.duplicateQuad(topBotQuad);
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.func_178210_d() == Direction.UP ? 0.5625f : 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            } else if (quad.func_178210_d() == dir.func_176746_e() || quad.func_178210_d() == dir.func_176735_f()) {
                boolean neg = dir.func_176743_c() == Direction.AxisDirection.NEGATIVE;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, neg ? 0.0f : 0.625f, 0.375f, neg ? 0.375f : 1.0f, 0.5625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    quadMap.get(null).add(sideQuad);
                }
                if (BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), neg ? 0.0f : 0.625f, 0.75f, neg ? 0.375f : 1.0f, 0.9375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    quadMap.get(null).add(sideQuad);
                }
            } else if (quad.func_178210_d() == dir) {
                BakedQuad frontQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(frontQuad, 0.4375f, 0.375f, 0.5625f, 0.5625f)) {
                    quadMap.get(quad.func_178210_d()).add(frontQuad);
                }
                if (BakedQuadTransformer.createSideQuad(frontQuad = ModelUtils.duplicateQuad(quad), 0.4375f, 0.75f, 0.5625f, 0.9375f)) {
                    quadMap.get(quad.func_178210_d()).add(frontQuad);
                }
            }
        }
    }

    public static IBakedModel createFenceModel(BlockState state, IBakedModel baseModel) {
        if (ModList.get().isLoaded("diagonalfences")) {
            return new FramedDiagonalFenceModel(state, baseModel);
        }
        return new FramedFenceModel(state, baseModel);
    }
}

