/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.renderer;

import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public abstract class GlassMeterRenderer
extends ItemStackTileEntityRenderer {
    public static final RenderType RENDER_TYPE = RenderType.func_228644_e_((ResourceLocation)GameRendering.EMPTY_TEXTURE);

    public static void addVertex(IVertexBuilder vertexBuilder, MatrixStack matrix, ColorARGB color, float x, float y, float u, float v) {
        vertexBuilder.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), x, y, 0.0f).func_225586_a_(color.getRed().value, color.getGreen().value, color.getBlue().value, color.getAlpha().value).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix.func_227866_c_().func_227872_b_(), 0.0f, 0.0f, 1.0f).func_181675_d();
    }

    public void func_239207_a_(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer renderBuffer, int combinedLight, int combinedOverlay) {
        this.renderModel(itemStack, matrixStack, renderBuffer, combinedLight, combinedOverlay);
        this.renderIndicators(itemStack, matrixStack, renderBuffer);
    }

    protected ItemRenderer getItemRenderer() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    protected abstract void renderIndicators(ItemStack var1, MatrixStack var2, IRenderTypeBuffer var3);

    protected void renderModel(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        RenderType rendertype = RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)true);
        IBakedModel model = this.getItemRenderer().func_184393_a(stack, null, null);
        IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.func_77962_s());
        Random random = new Random(42L);
        for (Direction direction : (Direction[])ArrayUtils.add((Object[])Direction.values(), null)) {
            this.getItemRenderer().func_229112_a_(matrix, builder, model.getQuads(null, direction, random, (IModelData)EmptyModelData.INSTANCE), stack, combinedLight, combinedOverlay);
        }
    }
}

